#include"../../Maid/FrameWork/Windows/CSingleWindowAppWindows.h"

#include"../../Maid/Graphic/CGraphic.h"
#include"../../Maid/Graphic/CModelFile.h"
#include"../../Maid/Graphic/CSurfaceRenderTarget.h"
#include"../../Maid/Graphic/CTextureRenderTarget.h"

#include"../../Maid/Storage/CStorage.h"

#include"../../Maid/Auxiliary/CString.h"
#include"../../Maid/Auxiliary/Windows/CTimer_timeGetTime.h"


#include"../../Maid/Input/CMouse.h"
#include"../../Maid/Input/CKeybord.h"

#include"../../Maid/template/counter.h"
using namespace Maid;



class CApp : public IGameThread
{
protected:
	void OnLocalSetup( APPCONFIG& conf )
	{
	//	conf.Graphic.IsSoftTnL = true;

	}

	void OnLocalEnd()
	{

	}

	void OnLocalBegin( const BEGINPARAM& param )
	{
		{
			//	OtBbN̏
			CGraphic::SCREENMODE mode;

			mode.Mode = CGraphic::SCREENMODE::TYPE_WINDOW;
			mode.Size = SIZE2DI(800,600);
			mode.RefreshRate = 0;
			mode.IsSoftTnL   = false;
			mode.IsWaitVSync = true;

			m_Graphic.Initialize( mode, param.pFontDriver, param.pInfo );
		}

		{
			m_Storage.Initialize( );
		}
		{
			//	L[͂̏
			m_Mouse.Initialize( param.pMouseDriver );
			m_Keybord.Initialize( param.pKeybordDriver, param.pCharCodeDriver );
		}

		model.Load( MAIDTEXT("box_vertex.lwo") );
		model_tex.Load( MAIDTEXT("box_texture.lwo") );

		while( true )
		{
			if( model.IsNowLoading() ) { ::Sleep(100); continue; }
			break;
		}
		while( true )
		{
			if( model_tex.IsNowLoading() ) { ::Sleep(100); continue; }
			break;
		}


		TargetC.Create( SIZE2DI(800,600), PIXELFORMAT_R08G08B08I );

		TargetZ.Create( TargetC.GetTextureSize(), PIXELFORMAT_D16 );

		camera.SetPerspective( DEGtoRAD(60), 800.0f/600.0f, 0.1f, 100.0f ); 
		camera.SetPosition( POINT3DF( 0,0,-5) ); 
		camera.SetTarget( POINT3DF( 0,0,0) );
		camera.SetUpVector( VECTOR3DF(0,1,0) );


		rot.Set( DEGtoRAD(0), DEGtoRAD(360), 100 );

	}

	void OnLocalLoop()
	{
		//	}EX̍XV
		m_Mouse.Update();

		//	L[{[h̍XV
		m_Keybord.Update();





		++rot;

		//	ŕ`施߂o
		m_Graphic.SetDepthStencil( TargetZ );
		m_Graphic.SetRenderTarget( TargetC );

		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x80) );
		m_Graphic.ClearRenderTargetZ( 1.0f );


		m_Graphic.SetCamera( camera );
		m_Graphic.BltModelR( model_tex, POINT3DF(0,0,0), rot, VECTOR3DF(1,0,0) );
		m_Graphic.BltModelR( model, POINT3DF(0,0,0), rot, VECTOR3DF(0,1,0) );

		m_Graphic.ResetRenderTarget();
		m_Graphic.ResetDepthStencil();

		m_Graphic.ClearRenderTargetColor( COLOR_A08R08G08B08I(0xFF,0x00,0x00,0x00) );
		m_Graphic.ClearRenderTargetZ( 1.0f );

		const RECT2DI rc(POINT2DI(0,0),SIZE2DI(400,300));
		const POINT2DI off( rc.w/2, rc.h/2 );

		m_Graphic.BltR( POINT2DF(400,300), TargetC, rc, rot, VECTOR3DF(0,0,1), off );


		{	//	eLXg̕\
			char* buf = 
				"eXg"
				;

			SPFONT pFont = m_Graphic.CreateFont( 0, SIZE2DI(16,32), true, false, false );
			m_Graphic.BltText( POINT2DF(0,0), pFont, COLOR_A08R08G08B08I(0xFF,0xFF,0xFF,0xFF), CString::ConvertSJIStoMAID(buf) );
		}

		//	̃t[
		OnNextFrame(m_Graphic);
		::Sleep(10);
	}


private:
	CGraphic	m_Graphic;
	CStorage	m_Storage;
	CMouse		m_Mouse;
	CKeybord	m_Keybord;
	CTextureRenderTarget TargetC;
	CSurfaceRenderTarget TargetZ;

	CModelFile model;
	CModelFile model_tex;
	CCamera camera;
	CLoopCounter<float> rot;

};


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	CSingleWindowAppWindows capp( SPGAMETHREAD( new CApp ) );
	return capp.Run( hInstance, hPrevInstance, lpCmdLine, nCmdShow );

}