/*
 * mdr32f9qx_spl.c
 *
 *  Created on: 1 нояб. 2018 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#include "MDR32F9Qx_config.h"
#include "mcu_nvic.h"
#include "cslr.h"
#include "mcu_rcc.h"

void NVIC_Init(const NVIC_InitTypeDef* x ){
    uint32_t grouping = NVIC_GetPriorityGrouping();
    uint32_t prio = NVIC_EncodePriority(grouping
                        , x->NVIC_IRQChannelPreemptionPriority
                        , x->NVIC_IRQChannelSubPriority
                        );
    NVIC_SetPriority((IRQn_Type)x->NVIC_IRQChannel, prio);
    if (x->NVIC_IRQChannelCmd == ENABLE){
        NVIC_EnableIRQ((IRQn_Type)x->NVIC_IRQChannel);
    }
    else
        NVIC_DisableIRQ((IRQn_Type)x->NVIC_IRQChannel);
}



#include "gpio.h"
#include "mcu_gpio.h"

void GPIO_StructInit_Digital(GPIO_InitTypeDef* x){
    GPIO_StructInit(x);
    x->PORT_MODE  = PORT_MODE_DIGITAL;
    x->PORT_SPEED = PORT_SPEED_MAXFAST;
}

void gpio_conf_pin(GPIO_TypeDef* port, unsigned pin){
    GPIO_InitTypeDef    GPIO_InitStructure;
    GPIO_StructInit_Digital(&GPIO_InitStructure);
    GPIO_InitStructure.PORT_Pin   = pin;
    GPIO_InitStructure.PORT_OE    = PORT_OE_IN;
    RST_CLK_PCLKcmd( RCC_GPIO(port), ENABLE);
    GPIO_Init(port, &GPIO_InitStructure);
}

void gpio_conf_pin(const GPIOFUNC_INIT* x){
    gpio_conf_pin(x->port, x->pins);
}

void gpio_conf_pout(GPIO_TypeDef* port, unsigned pin){
    GPIO_InitTypeDef    GPIO_InitStructure;
    GPIO_StructInit_Digital(&GPIO_InitStructure);
    GPIO_InitStructure.PORT_Pin   = pin;
    GPIO_InitStructure.PORT_OE    = PORT_OE_OUT;
    RST_CLK_PCLKcmd( RCC_GPIO(port), ENABLE);
    GPIO_Init(port, &GPIO_InitStructure);
}

void gpio_conf_pout_oc(GPIO_TypeDef* port, unsigned pin){
    GPIO_InitTypeDef    GPIO_InitStructure;
    GPIO_StructInit_Digital(&GPIO_InitStructure);
    //установлю требуемую подтяжку
    GPIO_InitStructure.PORT_Pin   = pin;
    GPIO_InitStructure.PORT_PULL_UP = PORT_PULL_UP_ON;
    //GPIO_InitStructure.PORT_OE    = PORT_OE_IN;
    //PORT_Init(port, &PORT_InitStructure);

    //чтобы не установить активный выход, сначала применю тип OD
    GPIO_InitStructure.PORT_PD    = PORT_PD_OPEN;
    GPIO_InitStructure.PORT_OE    = PORT_OE_OUT;
    RST_CLK_PCLKcmd( RCC_GPIO(port), ENABLE);
    GPIO_Init(port, &GPIO_InitStructure);
}

void gpio_conf_out(const PIN_INIT* x){
    RST_CLK_PCLKcmd( RCC_GPIO(x->port), ENABLE);
    uint32_t pins = 1 << x->pin;
    if (x->style& psINV){
        gpio_on(x->port, pins);
    }
    if ((x->style& psOD) == 0)
        gpio_conf_pout(x->port, pins);
    else
        gpio_conf_pout_oc(x->port, pins);
}

void gpio_conf_in(const PIN_INIT* x){
    gpio_conf_in(x, 1 << x->pin);
}

void gpio_conf_in(const PIN_INIT* x, unsigned pins) {
    RST_CLK_PCLKcmd( RCC_GPIO(x->port), ENABLE);
    GPIO_InitTypeDef    GPIO_InitStructure;
    GPIO_StructInit_Digital(&GPIO_InitStructure);
    GPIO_InitStructure.PORT_Pin   = pins;
    GPIO_InitStructure.PORT_OE    = PORT_OE_IN;
    if ((x->style& psPD) != 0)
        GPIO_InitStructure.PORT_PULL_DOWN = PORT_PULL_DOWN_ON;
    if ((x->style& psPU) != 0)
        GPIO_InitStructure.PORT_PULL_UP = PORT_PULL_UP_ON;
    GPIO_Init(x->port, &GPIO_InitStructure);
}

void gpio_conf_func(const GPIOFUNC_INIT* x){
    GPIO_InitTypeDef    GPIO_InitStructure;
    RST_CLK_PCLKcmd(RCC_GPIO(x->port), ENABLE );
    GPIO_StructInit_Digital(&GPIO_InitStructure);
    GPIO_InitStructure.PORT_Pin   = x->pins;
    GPIO_InitStructure.PORT_FUNC  = x->func;
    GPIO_InitStructure.PORT_MODE  = PORT_MODE_DIGITAL;
    GPIO_InitStructure.PORT_SPEED = PORT_SPEED_MAXFAST;
    PORT_Init(x->port, &GPIO_InitStructure);
}


void gpio_set_func(GPIO_TypeDef* port, unsigned pin, PORT_FUNC_TypeDef f){
    uint32_t tmpreg_FUNC   = port->FUNC;
    /* Form new values */
    int pos = 0;
    uint32_t mask_l = 0x00000003;
    for (; pin; pin >>= 1)
    {
      if (pin & 0x1)
      {
        tmpreg_FUNC   = (tmpreg_FUNC   & ~mask_l) | (f << (pos*2));
      }
      mask_l <<= 2;
      pos++;
    }
    port->FUNC   = fix_jtag_pins(port, tmpreg_FUNC);
}

void gpio_set_func(const GPIOFUNC_INIT* x){
    gpio_set_func(x->port, x->pins, x->func);
}

PORT_FUNC_TypeDef gpio_func(GPIO_TypeDef* port, unsigned pin){
    uint32_t tmpreg_FUNC   = port->FUNC;
    for (; pin; pin >>= 1, tmpreg_FUNC >>= 2){
        if (pin & 0x1){
            return (PORT_FUNC_TypeDef)(tmpreg_FUNC & 3);
        }
    }
    return (PORT_FUNC_TypeDef)0;
}

PORT_FUNC_TypeDef gpio_func(const GPIOFUNC_INIT* x){
    return gpio_func(x->port, x->pins);
}



uint32_t gpio_on(const PIN_INIT* x){
    uint32_t pins = 1 << x->pin;
    if ((x->style & psINV) == 0)
        return gpio_on(x->port, pins);
    else
        return gpio_off(x->port, pins);
}

uint32_t gpio_off(const PIN_INIT* x){
    uint32_t pins = 1 << x->pin;
    if ((x->style & psINV) == 0)
        return gpio_off(x->port, pins);
    else
        return gpio_on(x->port, pins);
}

uint32_t gpio_pins(const PIN_INIT* x){
    uint32_t pins = x->port->RXTX;
    if ((x->style & psINV) != 0)
        pins = ~pins;
    pins &= 1 << x->pin;
    return pins;
}

uint32_t gpio_styled_pins(GPIO_TypeDef* port, unsigned pin, unsigned style){
    return GPIO_STYLED_PINS(port, pin, style);
}

uint32_t gpio_styled_pouts(GPIO_TypeDef* port, unsigned pin, unsigned style){
    return GPIO_STYLED_POUTS(port, pin, style);
}

uint32_t gpio_on(GPIO_TypeDef* port, unsigned pin){
    return GPIO_ON(port, pin);
}
uint32_t gpio_set(GPIO_TypeDef* port, unsigned pin, unsigned mask){
    return GPIO_SET(port, pin, mask);
}
uint32_t gpio_off(GPIO_TypeDef* port, unsigned pin){
    return GPIO_OFF(port, pin);
}
uint32_t gpio_twist(GPIO_TypeDef* port, unsigned pin){
    return GPIO_TWIST(port, pin);
}

uint32_t fix_jtag_pins(GPIO_TypeDef* port, unsigned pin){
    return FIX_JTAG_PINS(port, pin);
}



#include "mcu_can.h"
int CAN_SetBaud(CAN_TypeDef* CANx, unsigned baud){
    uint32_t tmp_CONTROL = CANx->BITTMNG;
    // adjust baudrate
    unsigned bittime = 1 //Sync seg
                       + 1+CSL_FEXT(tmp_CONTROL, CAN_BITTMNG_PSEG)
                       + 1+CSL_FEXT(tmp_CONTROL, CAN_BITTMNG_SEG1)
                       + 1+CSL_FEXT(tmp_CONTROL, CAN_BITTMNG_SEG2)
                       ;
    unsigned brp = (SystemCoreClock/(bittime*baud))-1;
    CSL_FINS( CANx->BITTMNG, CAN_BITTMNG_BRP , brp );

    return 0;
}



//  chip specific perifery
#ifdef MDR1986VE94T

const GPIOFUNC_INIT UART1A_GPIO = PINFUNC_DEF(MDR_PORTA, (PORT_Pin_6 | PORT_Pin_7), PORT_FUNC_OVERRID);
const GPIOFUNC_INIT UART1B_GPIO = PINFUNC_DEF(MDR_PORTB, (PORT_Pin_5 | PORT_Pin_6), PORT_FUNC_ALTER);
const GPIOFUNC_INIT UART1D_GPIO = PINFUNC_DEF(MDR_PORTD, (PORT_Pin_7 | PORT_Pin_8), PORT_FUNC_OVERRID);
const GPIOFUNC_INIT UART1E_GPIO = PINFUNC_DEF(MDR_PORTE, (PORT_Pin_12 | PORT_Pin_13), PORT_FUNC_OVERRID);

const GPIOFUNC_INIT UART2D_GPIO = PINFUNC_DEF(MDR_PORTD, (PORT_Pin_0 | PORT_Pin_1), PORT_FUNC_ALTER);
const GPIOFUNC_INIT UART2F_GPIO = PINFUNC_DEF(MDR_PORTF, (PORT_Pin_0 | PORT_Pin_1), PORT_FUNC_OVERRID);

#endif
