/*
 * wdt.h
 *
 *  Created on: 6 мая 2019 г.
 *      Author: Lityagin Aleksandr
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 */

#ifndef STM32_AGV_WDT_H_
#define STM32_AGV_WDT_H_

#include <mcu-chip.h>
#include <project-conf.h>
#include <c_compat.h>

typedef IWDG_TypeDef        WDT_t;
typedef IWDG_HandleTypeDef  hWDT_t;

#ifdef STM32F4
#define IWDG1 IWDG
#endif
//#define IWDG1 WDT

extern IWDG_HandleTypeDef   hwdt;
#define     WDT     (&hwdt)

//< WDT_PIN - задает пин для внешнего вочдога, котрый будет дергаться
//              на каждый wdt_reset
//#define WDT_PIN
//< WDT_DISABLE - выключает старт внутреннего вочдога
//#define WDT_DISABLE
//< WDT_TO_MS - задает таймаут внутреннего вочдога
//#define WDT_TO_MS

#ifdef __cplusplus
extern "C" {
#endif

#ifndef WDT_PIN

INLINE
void wdt_reset(hWDT_t* x){
    HAL_IWDG_Refresh(x);
}

#else
void wdt_reset(hWDT_t* x);
#endif

void wdt_init();
// печать информации о статусе вочдога
void wdt_print();

#ifdef __cplusplus
}
#endif



#ifdef __cplusplus

#ifdef WDT_PIN
#include <gpio.h>
extern const PIN_INIT     WDT_PIN;
#endif

#endif



#endif /* STM32_AGV_WDT_H_ */
