/*
 * r_sci_uartx.h
 *
 *  Created on: 19/05/2021 г.
 *      Author: alexraynepe196@gmail.com
 * ----------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
 * ----------------------------------------------------------------------
 *   renesas UART FSP API extentions
 */

#ifndef BSP_CPU_DEV_R_SCI_UARTX_H_
#define BSP_CPU_DEV_R_SCI_UARTX_H_

#include "r_sci_uart.h"
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif


/// @brief check that R_SCI_UART_Read active
static inline
bool R_SCI_UART_rx_busy(uart_ctrl_t * p_api_ctrl){
    sci_uart_instance_ctrl_t* self = (sci_uart_instance_ctrl_t*)p_api_ctrl;
    return self->rx_dest_bytes > 0;
}

/// @brief check that R_SCI_UART_Write active
bool R_SCI_UART_tx_busy(uart_ctrl_t * p_api_ctrl);

/// @brief receive data pointer
/// @return != NULL - pointer to receiver buffer tail
///         == NULL - read not active
uint8_t*  R_SCI_UART_rx_tail(uart_ctrl_t * const p_api_ctrl);


#if SCI_UART_CFG_DTC_SUPPORTED
/// @brief receive data pointer
/// @return != NULL - pointer to receiver buffer head
///         == NULL - read not active or not available
uint8_t*  R_SCI_UART_rx_head(uart_ctrl_t * const p_api_ctrl);
#endif



#ifdef __cplusplus
}
#endif

#endif /* BSP_CPU_DEV_R_SCI_UARTX_H_ */
