/*
 * r_ssp_spi.h
 *
 *  Created on: 3/06/2021
 *      Author: alexrayne <alexraynepe196@gmail.com>
 * ------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
      ssp_hal device driver over Renesas SPI unit
 */

#ifndef BSP_CPU_DEV_R_SSP_SPI_H_
#define BSP_CPU_DEV_R_SSP_SPI_H_

#include <ssp_hal.h>
#include "mcu_ssp.h"
#include "r_spi.h"



enum SPIPortStateID{
    SPI_STATE_ERROR = -1,        //< отправка завершена
    SPI_STATE_IDLE  = 0,

    SPI_STATE_ABORT,        //< отправка завершена
    SPI_STATE_DONE,         //< отправка завершена

    SPI_STATE_HEAD,         //< отправка загогловка сообщения
    SPI_STATE_BODY,         //< отправка тела сообщения

};
typedef enum SPIPortStateID SPIPortStateID;

struct SSP_SPIPort {
    SSP_IOPort  spi;
    SPI_TypeDef* regs;

    //ExclusiveCheck      access;
    //Mutex               access;

    SSPMessage*         msg;

    // TODO: стоит этот статус в сообщение переложить?
    volatile SPIPortStateID      msg_status;

    // актуальная частота SCK
    unsigned            fsck_hz;
    // актуальный режим порта
    uint32_t            ssp_mode;
    spi_bit_width_t     ssp_bw;

    spi_instance_ctrl_t*    ctrl;
    transfer_info_t *       tx_dma;
    transfer_info_t *       rx_dma;

    transfer_ctrl_t *       tx_ctl;
    transfer_ctrl_t *       rx_ctl;
};
typedef struct SSP_SPIPort  SSP_SPIPort;

DevResult ssp_spi_init(SSP_SPIPort* this, spi_instance_ctrl_t* spi, const spi_cfg_t* spi_cfg);



#endif /* BSP_CPU_DEV_R_SSP_SPI_H_ */
