/*
 * rtimer-arch-agt.h
 *
 *  Created on: 16/04/2021.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
    this is implementation of rtimer at AGT0 for ContikiOS
 */

#ifndef BSP_CPU_RTIMER_ARCH_AGT_H_
#define BSP_CPU_RTIMER_ARCH_AGT_H_

//#include <sys/rtimer.h>

/*---------------------------------------------------------------------------*/
/**
 * \addtogroup arm-clocks
 * @{
 *
 * \defgroup systick-rtimer SysTick rtimer
 *
 * Implementation of the rtimer module for the SysTick clocks
 * @{
 */
/**
 * \file
 * Header file for the CC13xx/CC26xx rtimer driver
 */
/*---------------------------------------------------------------------------*/
//#include "contiki-conf.h"
#include "rtimer_agt.h"
/*---------------------------------------------------------------------------*/


// utilise AGT chA for contiki rtimer
#define rtimer_arch_schedule(t)     rtimer_agt_schedule(t)



#endif /* BSP_CPU_RTIMER_ARCH_AGT_H_ */
