/*
 * mcu_exti.h
 *
 *  Created on: 13/04/2021
 *      Author: alexraynepe196@gmail.com
 * -----------------------------------------------------------------------
 *
 */

#ifndef BSP_CPU_MCU_EXTI_H_
#define BSP_CPU_MCU_EXTI_H_

#include <mcu-chip.h>
#include "mcu_nvic.h"

#define _EXTI_CAT2(a,b)    a##b
#define _EXTI_CAT3(a,b,c)  a##b##c

/// @brief FSP configurator generates this IRQn_Type ID in vector_data.h
/// @arg n - digit 0..7
#define EXTI_IRQn(n) _EXTI_CAT3(ICU_IRQ, n, _IRQn)
#define EXTIn(n)     _EXTI_CAT2(EXTI, n)


/** Condition that will trigger an interrupt when detected. */
typedef enum GPIOExtITrigger
{
    EXTI_TRIG_FALLING   = 0,   ///< Falling edge trigger
    EXTI_TRIG_RISING    = 1,   ///< Rising edge trigger
    EXTI_TRIG_BOTH_EDGE = 2,   ///< Both edges trigger
    EXTI_TRIG_LEVEL_LOW = 3,   ///< Low level trigger
} GPIOExtITrigger;

/** External IRQ input pin digital filtering sample clock divisor settings. The digital filter rejects trigger
 * conditions that are shorter than 3 periods of the filter clock.
 */
typedef enum GPIOExtIFilter
{
    EXTI_PCLK_Pos   = 4,
    EXTI_PCLK_DIV   = 3 <<EXTI_PCLK_Pos ,   //< mask

    EXTI_PCLK_DIV1  = 0                 ,   ///< Filter using PCLK divided by 1
    EXTI_PCLK_DIV8  = 1 <<EXTI_PCLK_Pos ,   ///< Filter using PCLK divided by 8
    EXTI_PCLK_DIV32 = 2 <<EXTI_PCLK_Pos ,   ///< Filter using PCLK divided by 32
    EXTI_PCLK_DIV64 = 3 <<EXTI_PCLK_Pos ,   ///< Filter using PCLK divided by 64

    EXTI_FILTER     = 0x80,                 ///<  Digital filter is enabled.
} GPIOExtIFilter;

typedef enum EXTILineID {
    EXTI0  = 0,
    EXTI1 ,
    EXTI2 ,
    EXTI3 ,
    EXTI4 ,
    EXTI5 ,
    EXTI6 ,
    EXTI7 ,
} EXTILineID;

/// @arg exti_options - GPIOExtITrigger | GPIOExtIFilter
void EXTI_Init( NVIC_InitTypeDef irq, EXTILineID exti_line, uint32_t exti_options);



#endif /* BSP_CPU_MCU_EXTI_H_ */
