/*
 * trace.h
 * cp1251 ru
 *
 *  Created on: 21 . 2016 .
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  -------------------------------------------------------------------------
 *      :
 *   -  
 */

#ifndef MAIN_INC_TRACE_H_
#define MAIN_INC_TRACE_H_

#include <c_compat.h>
#include <bsp/hw.h>
#include "mcu_gpio.h"

#ifdef __cplusplus
extern "C" {
#endif



void trace_init(void);

//*     
//*     ,  ,  
#define probe_none_id   0
#define probe_none_on(x)
#define probe_none_off(x)
#define probe_none_twist(x)
#define is_probe_none(x) 0

#define probe_pin1_id   1
#define probe_pin2_id   2
#define probe_pin3_id   3
#define probe_pin4_id   4
#define probe_pin5_id   5
#define probe_pin6_id   6
#define probe_pin7_id   7
#define probe_pin8_id   8
#define probe_pin9_id   9
#define probe_pin10_id  10
#define probe_pin11_id  11
#define probe_pin12_id  12




#define probepin(N, PIN) \
INLINE bool is_probe_##N(void)      { return GPIO_GETPIN(PIN); } \
INLINE void probe_##N##_on(void)    { GPIO_SETPIN(PIN); } \
INLINE void probe_##N##_off(void)   { GPIO_CLRPIN(PIN); } \
INLINE void probe_##N##_twist(void) { GPIO_INVPIN(PIN);}



probepin(pin1, TRACE_PIN_1)
probepin(pin2, TRACE_PIN_2)
probepin(pin3, TRACE_PIN_3)
probepin(pin4, TRACE_PIN_4)
probepin(pin5, TRACE_PIN_5)
probepin(pin6, TRACE_PIN_6)
probepin(pin7, TRACE_PIN_7)
probepin(pin8, TRACE_PIN_8)
probepin(pin9, TRACE_PIN_9)
probepin(pin10, TRACE_PIN_A)
probepin(pin11, TRACE_PIN_B)
probepin(pin12, TRACE_PIN_C)



//*         
#define trace_probe_on(name) probe_pin_on(trace_##name)
#define trace_probe_off(name) probe_pin_off(trace_##name)

#define TRC_ASSTR(name) name
#define TRC_ASSTR2(name) TRC_ASSTR(name)
#define TRC_CATSTR(name,suf) name##suf
#define TRC_CATSTR2(name,suf) TRC_CATSTR(name,suf)

#define PROBESTR(name, suf) TRC_CATSTR(name, suf)
//*        trace_<name>_on/off()
#define trace_probe(name) \
enum{ trace_##name##_id = TRC_CATSTR2( trace_##name, _id) };\
INLINE void trace_##name##_on(void)\
{PROBESTR(TRC_ASSTR(trace_##name), _on)();};\
INLINE void trace_##name##_off(void)\
{PROBESTR(TRC_ASSTR(trace_##name),_off)();};\
INLINE void trace_##name##_twist(void)\
{PROBESTR(TRC_ASSTR(trace_##name),_twist)();};\
INLINE uint32_t is_trace_##name(void)\
{return PROBESTR(is_,TRC_ASSTR(trace_##name))();};

#define TRACEID(name) TRC_CATSTR2(name, _id)

#define trace_need(name) \
        INLINE uint32_t is_trace_##name(void) {return false;}\
        INLINE void trace_##name##_on(void) {;}\
        INLINE void trace_##name##_off(void) {;}\
        INLINE void trace_##name##_twist(void) {;}


#include <trace-port.h>


#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
#define TRACE_GUARD(name, tr) struct TRC_ASSTR(trace_guard_##name) { \
        TRC_ASSTR(trace_guard_##name)(){ trace_##tr##_on();};\
        TRC_ASSTR(~trace_guard_##name)(){ trace_##tr##_off();};\
    } trace_##name

#endif

#endif /* MAIN_INC_TRACE_H_ */
