/******************************************************************************/
/* DISCLAIMER                                                                 */
/* This software is supplied by Renesas Electronics Corporation and is only   */
/* intended for use with Renesas products. No other uses are authorized.This  */
/* software is owned by Renesas Electronics Corporation and is protected      */
/* under all applicable laws, including copyright laws.                       */
/* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES          */
/* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING  */
/* BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR */
/* PURPOSE AND NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY           */
/* DISCLAIMED.                                                                */
/* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS     */
/* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE       */
/* LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL      */
/* DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS    */
/* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.           */
/* Renesas reserves the right, without notice, to make changes to this        */
/* software and to discontinue the availability of this software.             */
/* By using this software, you agree to the additional terms and conditions   */
/* found by accessing the following link:                                     */
/* http://www.renesas.com/disclaimer                                          */
/*                                                                            */
/* Device     : RL78/R5F104ML                                                 */
/* File Name  : R5F104ML.h                                                    */
/* Abstract   : Definition of Special Function Register (SFR)                 */
/* History    : V2.30  [Device File version]                                  */
/* Options    : -df=DR5F104ML.DVF -o=R5F104ML.h -f                            */
/* Date       : 2018/05/11                                                    */
/* Version    : V1.08.00.01  [df2iodef.exe version]                           */
/* This is a typical example.                                                 */
/*                                                                            */
/******************************************************************************/
#ifndef __R5F104MLIODEFINE_HEADER__
#define __R5F104MLIODEFINE_HEADER__

typedef struct
{
    unsigned char no0:1;
    unsigned char no1:1;
    unsigned char no2:1;
    unsigned char no3:1;
    unsigned char no4:1;
    unsigned char no5:1;
    unsigned char no6:1;
    unsigned char no7:1;
} __bitf_T;

typedef struct
{
    unsigned char no0:1;
    unsigned char no1:1;
    unsigned char no2:1;
    unsigned char no3:1;
    unsigned char no4:1;
    unsigned char no5:1;
    unsigned char no6:1;
    unsigned char no7:1;
    unsigned char no8:1;
    unsigned char no9:1;
    unsigned char no10:1;
    unsigned char no11:1;
    unsigned char no12:1;
    unsigned char no13:1;
    unsigned char no14:1;
    unsigned char no15:1;
} __bitf_T2;



#define ADM2         (*(volatile __near unsigned char  *)0x10)
#define ADM2_bit     (*(volatile __near __bitf_T *)0x10)
#define ADTYP        (((volatile __near __bitf_T *)0x10)->no0)
#define AWC          (((volatile __near __bitf_T *)0x10)->no2)
#define ADRCK        (((volatile __near __bitf_T *)0x10)->no3)
#define ADUL         (*(volatile __near unsigned char  *)0x11)
#define ADLL         (*(volatile __near unsigned char  *)0x12)
#define ADTES        (*(volatile __near unsigned char  *)0x13)
#define PU0          (*(volatile __near unsigned char  *)0x30)
#define PU0_bit      (*(volatile __near __bitf_T *)0x30)
#define PU1          (*(volatile __near unsigned char  *)0x31)
#define PU1_bit      (*(volatile __near __bitf_T *)0x31)
#define PU3          (*(volatile __near unsigned char  *)0x33)
#define PU3_bit      (*(volatile __near __bitf_T *)0x33)
#define PU4          (*(volatile __near unsigned char  *)0x34)
#define PU4_bit      (*(volatile __near __bitf_T *)0x34)
#define PU5          (*(volatile __near unsigned char  *)0x35)
#define PU5_bit      (*(volatile __near __bitf_T *)0x35)
#define PU6          (*(volatile __near unsigned char  *)0x36)
#define PU6_bit      (*(volatile __near __bitf_T *)0x36)
#define PU7          (*(volatile __near unsigned char  *)0x37)
#define PU7_bit      (*(volatile __near __bitf_T *)0x37)
#define PU10         (*(volatile __near unsigned char  *)0x3A)
#define PU10_bit     (*(volatile __near __bitf_T *)0x3A)
#define PU11         (*(volatile __near unsigned char  *)0x3B)
#define PU11_bit     (*(volatile __near __bitf_T *)0x3B)
#define PU12         (*(volatile __near unsigned char  *)0x3C)
#define PU12_bit     (*(volatile __near __bitf_T *)0x3C)
#define PU14         (*(volatile __near unsigned char  *)0x3E)
#define PU14_bit     (*(volatile __near __bitf_T *)0x3E)
#define PIM0         (*(volatile __near unsigned char  *)0x40)
#define PIM0_bit     (*(volatile __near __bitf_T *)0x40)
#define PIM1         (*(volatile __near unsigned char  *)0x41)
#define PIM1_bit     (*(volatile __near __bitf_T *)0x41)
#define PIM3         (*(volatile __near unsigned char  *)0x43)
#define PIM3_bit     (*(volatile __near __bitf_T *)0x43)
#define PIM4         (*(volatile __near unsigned char  *)0x44)
#define PIM4_bit     (*(volatile __near __bitf_T *)0x44)
#define PIM5         (*(volatile __near unsigned char  *)0x45)
#define PIM5_bit     (*(volatile __near __bitf_T *)0x45)
#define PIM14        (*(volatile __near unsigned char  *)0x4E)
#define PIM14_bit    (*(volatile __near __bitf_T *)0x4E)
#define POM0         (*(volatile __near unsigned char  *)0x50)
#define POM0_bit     (*(volatile __near __bitf_T *)0x50)
#define POM1         (*(volatile __near unsigned char  *)0x51)
#define POM1_bit     (*(volatile __near __bitf_T *)0x51)
#define POM3         (*(volatile __near unsigned char  *)0x53)
#define POM3_bit     (*(volatile __near __bitf_T *)0x53)
#define POM4         (*(volatile __near unsigned char  *)0x54)
#define POM4_bit     (*(volatile __near __bitf_T *)0x54)
#define POM5         (*(volatile __near unsigned char  *)0x55)
#define POM5_bit     (*(volatile __near __bitf_T *)0x55)
#define POM7         (*(volatile __near unsigned char  *)0x57)
#define POM7_bit     (*(volatile __near __bitf_T *)0x57)
#define POM14        (*(volatile __near unsigned char  *)0x5E)
#define POM14_bit    (*(volatile __near __bitf_T *)0x5E)
#define PMC0         (*(volatile __near unsigned char  *)0x60)
#define PMC0_bit     (*(volatile __near __bitf_T *)0x60)
#define PMC1         (*(volatile __near unsigned char  *)0x61)
#define PMC1_bit     (*(volatile __near __bitf_T *)0x61)
#define PMC10        (*(volatile __near unsigned char  *)0x6A)
#define PMC10_bit    (*(volatile __near __bitf_T *)0x6A)
#define PMC12        (*(volatile __near unsigned char  *)0x6C)
#define PMC12_bit    (*(volatile __near __bitf_T *)0x6C)
#define PMC14        (*(volatile __near unsigned char  *)0x6E)
#define PMC14_bit    (*(volatile __near __bitf_T *)0x6E)
#define NFEN0        (*(volatile __near unsigned char  *)0x70)
#define NFEN0_bit    (*(volatile __near __bitf_T *)0x70)
#define NFEN1        (*(volatile __near unsigned char  *)0x71)
#define NFEN1_bit    (*(volatile __near __bitf_T *)0x71)
#define NFEN2        (*(volatile __near unsigned char  *)0x72)
#define NFEN2_bit    (*(volatile __near __bitf_T *)0x72)
#define ISC          (*(volatile __near unsigned char  *)0x73)
#define ISC_bit      (*(volatile __near __bitf_T *)0x73)
#define TIS0         (*(volatile __near unsigned char  *)0x74)
#define ADPC         (*(volatile __near unsigned char  *)0x76)
#define PIOR0        (*(volatile __near unsigned char  *)0x77)
#define IAWCTL       (*(volatile __near unsigned char  *)0x78)
#define PIOR1        (*(volatile __near unsigned char  *)0x79)
#define PER1         (*(volatile __near unsigned char  *)0x7A)
#define PER1_bit     (*(volatile __near __bitf_T *)0x7A)
#define TRJ0EN       (((volatile __near __bitf_T *)0x7A)->no0)
#define DTCEN        (((volatile __near __bitf_T *)0x7A)->no3)
#define TRD0EN       (((volatile __near __bitf_T *)0x7A)->no4)
#define CMPEN        (((volatile __near __bitf_T *)0x7A)->no5)
#define TRGEN        (((volatile __near __bitf_T *)0x7A)->no6)
#define DACEN        (((volatile __near __bitf_T *)0x7A)->no7)
#define PMS          (*(volatile __near unsigned char  *)0x7B)
#define PMS_bit      (*(volatile __near __bitf_T *)0x7B)
#define GDIDIS       (*(volatile __near unsigned char  *)0x7D)
#define GDIDIS_bit   (*(volatile __near __bitf_T *)0x7D)
#define DFLCTL       (*(volatile __near unsigned char  *)0x90)
#define DFLCTL_bit   (*(volatile __near __bitf_T *)0x90)
#define DFLEN        (((volatile __near __bitf_T *)0x90)->no0)
#define HIOTRM       (*(volatile __near unsigned char  *)0xA0)
#define HOCODIV      (*(volatile __near unsigned char  *)0xA8)
#define PER0         (*(volatile __near unsigned char  *)0xF0)
#define PER0_bit     (*(volatile __near __bitf_T *)0xF0)
#define TAU0EN       (((volatile __near __bitf_T *)0xF0)->no0)
#define TAU1EN       (((volatile __near __bitf_T *)0xF0)->no1)
#define SAU0EN       (((volatile __near __bitf_T *)0xF0)->no2)
#define SAU1EN       (((volatile __near __bitf_T *)0xF0)->no3)
#define IICA0EN      (((volatile __near __bitf_T *)0xF0)->no4)
#define ADCEN        (((volatile __near __bitf_T *)0xF0)->no5)
#define IICA1EN      (((volatile __near __bitf_T *)0xF0)->no6)
#define RTCEN        (((volatile __near __bitf_T *)0xF0)->no7)
#define OSMC         (*(volatile __near unsigned char  *)0xF3)
#define RPECTL       (*(volatile __near unsigned char  *)0xF5)
#define RPECTL_bit   (*(volatile __near __bitf_T *)0xF5)
#define RPEF         (((volatile __near __bitf_T *)0xF5)->no0)
#define RPERDIS      (((volatile __near __bitf_T *)0xF5)->no7)
#define BCDADJ       (*(volatile __near unsigned char  *)0xFE)
#define SSR00        (*(volatile __near unsigned short *)0x100)
#define SSR00L       (*(volatile __near unsigned char  *)0x100)
#define SSR01        (*(volatile __near unsigned short *)0x102)
#define SSR01L       (*(volatile __near unsigned char  *)0x102)
#define SSR02        (*(volatile __near unsigned short *)0x104)
#define SSR02L       (*(volatile __near unsigned char  *)0x104)
#define SSR03        (*(volatile __near unsigned short *)0x106)
#define SSR03L       (*(volatile __near unsigned char  *)0x106)
#define SIR00        (*(volatile __near unsigned short *)0x108)
#define SIR00L       (*(volatile __near unsigned char  *)0x108)
#define SIR01        (*(volatile __near unsigned short *)0x10A)
#define SIR01L       (*(volatile __near unsigned char  *)0x10A)
#define SIR02        (*(volatile __near unsigned short *)0x10C)
#define SIR02L       (*(volatile __near unsigned char  *)0x10C)
#define SIR03        (*(volatile __near unsigned short *)0x10E)
#define SIR03L       (*(volatile __near unsigned char  *)0x10E)
#define SMR00        (*(volatile __near unsigned short *)0x110)
#define SMR01        (*(volatile __near unsigned short *)0x112)
#define SMR02        (*(volatile __near unsigned short *)0x114)
#define SMR03        (*(volatile __near unsigned short *)0x116)
#define SCR00        (*(volatile __near unsigned short *)0x118)
#define SCR01        (*(volatile __near unsigned short *)0x11A)
#define SCR02        (*(volatile __near unsigned short *)0x11C)
#define SCR03        (*(volatile __near unsigned short *)0x11E)
#define SE0          (*(volatile __near unsigned short *)0x120)
#define SE0L         (*(volatile __near unsigned char  *)0x120)
#define SE0L_bit     (*(volatile __near __bitf_T *)0x120)
#define SS0          (*(volatile __near unsigned short *)0x122)
#define SS0L         (*(volatile __near unsigned char  *)0x122)
#define SS0L_bit     (*(volatile __near __bitf_T *)0x122)
#define ST0          (*(volatile __near unsigned short *)0x124)
#define ST0L         (*(volatile __near unsigned char  *)0x124)
#define ST0L_bit     (*(volatile __near __bitf_T *)0x124)
#define SPS0         (*(volatile __near unsigned short *)0x126)
#define SPS0L        (*(volatile __near unsigned char  *)0x126)
#define SO0          (*(volatile __near unsigned short *)0x128)
#define SOE0         (*(volatile __near unsigned short *)0x12A)
#define SOE0L        (*(volatile __near unsigned char  *)0x12A)
#define SOE0L_bit    (*(volatile __near __bitf_T *)0x12A)
#define SOL0         (*(volatile __near unsigned short *)0x134)
#define SOL0L        (*(volatile __near unsigned char  *)0x134)
#define SSC0         (*(volatile __near unsigned short *)0x138)
#define SSC0L        (*(volatile __near unsigned char  *)0x138)
#define SSR10        (*(volatile __near unsigned short *)0x140)
#define SSR10L       (*(volatile __near unsigned char  *)0x140)
#define SSR11        (*(volatile __near unsigned short *)0x142)
#define SSR11L       (*(volatile __near unsigned char  *)0x142)
#define SSR12        (*(volatile __near unsigned short *)0x144)
#define SSR12L       (*(volatile __near unsigned char  *)0x144)
#define SSR13        (*(volatile __near unsigned short *)0x146)
#define SSR13L       (*(volatile __near unsigned char  *)0x146)
#define SIR10        (*(volatile __near unsigned short *)0x148)
#define SIR10L       (*(volatile __near unsigned char  *)0x148)
#define SIR11        (*(volatile __near unsigned short *)0x14A)
#define SIR11L       (*(volatile __near unsigned char  *)0x14A)
#define SIR12        (*(volatile __near unsigned short *)0x14C)
#define SIR12L       (*(volatile __near unsigned char  *)0x14C)
#define SIR13        (*(volatile __near unsigned short *)0x14E)
#define SIR13L       (*(volatile __near unsigned char  *)0x14E)
#define SMR10        (*(volatile __near unsigned short *)0x150)
#define SMR11        (*(volatile __near unsigned short *)0x152)
#define SMR12        (*(volatile __near unsigned short *)0x154)
#define SMR13        (*(volatile __near unsigned short *)0x156)
#define SCR10        (*(volatile __near unsigned short *)0x158)
#define SCR11        (*(volatile __near unsigned short *)0x15A)
#define SCR12        (*(volatile __near unsigned short *)0x15C)
#define SCR13        (*(volatile __near unsigned short *)0x15E)
#define SE1          (*(volatile __near unsigned short *)0x160)
#define SE1L         (*(volatile __near unsigned char  *)0x160)
#define SE1L_bit     (*(volatile __near __bitf_T *)0x160)
#define SS1          (*(volatile __near unsigned short *)0x162)
#define SS1L         (*(volatile __near unsigned char  *)0x162)
#define SS1L_bit     (*(volatile __near __bitf_T *)0x162)
#define ST1          (*(volatile __near unsigned short *)0x164)
#define ST1L         (*(volatile __near unsigned char  *)0x164)
#define ST1L_bit     (*(volatile __near __bitf_T *)0x164)
#define SPS1         (*(volatile __near unsigned short *)0x166)
#define SPS1L        (*(volatile __near unsigned char  *)0x166)
#define SO1          (*(volatile __near unsigned short *)0x168)
#define SOE1         (*(volatile __near unsigned short *)0x16A)
#define SOE1L        (*(volatile __near unsigned char  *)0x16A)
#define SOE1L_bit    (*(volatile __near __bitf_T *)0x16A)
#define SOL1         (*(volatile __near unsigned short *)0x174)
#define SOL1L        (*(volatile __near unsigned char  *)0x174)
#define SSC1         (*(volatile __near unsigned short *)0x178)
#define SSC1L        (*(volatile __near unsigned char  *)0x178)
#define TCR00        (*(volatile __near unsigned short *)0x180)
#define TCR01        (*(volatile __near unsigned short *)0x182)
#define TCR02        (*(volatile __near unsigned short *)0x184)
#define TCR03        (*(volatile __near unsigned short *)0x186)
#define TMR00        (*(volatile __near unsigned short *)0x190)
#define TMR01        (*(volatile __near unsigned short *)0x192)
#define TMR02        (*(volatile __near unsigned short *)0x194)
#define TMR03        (*(volatile __near unsigned short *)0x196)
#define TSR00        (*(volatile __near unsigned short *)0x1A0)
#define TSR00L       (*(volatile __near unsigned char  *)0x1A0)
#define TSR01        (*(volatile __near unsigned short *)0x1A2)
#define TSR01L       (*(volatile __near unsigned char  *)0x1A2)
#define TSR02        (*(volatile __near unsigned short *)0x1A4)
#define TSR02L       (*(volatile __near unsigned char  *)0x1A4)
#define TSR03        (*(volatile __near unsigned short *)0x1A6)
#define TSR03L       (*(volatile __near unsigned char  *)0x1A6)
#define TE0          (*(volatile __near unsigned short *)0x1B0)
#define TE0L         (*(volatile __near unsigned char  *)0x1B0)
#define TE0L_bit     (*(volatile __near __bitf_T *)0x1B0)
#define TS0          (*(volatile __near unsigned short *)0x1B2)
#define TS0L         (*(volatile __near unsigned char  *)0x1B2)
#define TS0L_bit     (*(volatile __near __bitf_T *)0x1B2)
#define TT0          (*(volatile __near unsigned short *)0x1B4)
#define TT0L         (*(volatile __near unsigned char  *)0x1B4)
#define TT0L_bit     (*(volatile __near __bitf_T *)0x1B4)
#define TPS0         (*(volatile __near unsigned short *)0x1B6)
#define TO0          (*(volatile __near unsigned short *)0x1B8)
#define TO0L         (*(volatile __near unsigned char  *)0x1B8)
#define TOE0         (*(volatile __near unsigned short *)0x1BA)
#define TOE0L        (*(volatile __near unsigned char  *)0x1BA)
#define TOE0L_bit    (*(volatile __near __bitf_T *)0x1BA)
#define TOL0         (*(volatile __near unsigned short *)0x1BC)
#define TOL0L        (*(volatile __near unsigned char  *)0x1BC)
#define TOM0         (*(volatile __near unsigned short *)0x1BE)
#define TOM0L        (*(volatile __near unsigned char  *)0x1BE)
#define TCR10        (*(volatile __near unsigned short *)0x1C0)
#define TCR11        (*(volatile __near unsigned short *)0x1C2)
#define TCR12        (*(volatile __near unsigned short *)0x1C4)
#define TCR13        (*(volatile __near unsigned short *)0x1C6)
#define TMR10        (*(volatile __near unsigned short *)0x1D0)
#define TMR11        (*(volatile __near unsigned short *)0x1D2)
#define TMR12        (*(volatile __near unsigned short *)0x1D4)
#define TMR13        (*(volatile __near unsigned short *)0x1D6)
#define TSR10        (*(volatile __near unsigned short *)0x1E0)
#define TSR10L       (*(volatile __near unsigned char  *)0x1E0)
#define TSR11        (*(volatile __near unsigned short *)0x1E2)
#define TSR11L       (*(volatile __near unsigned char  *)0x1E2)
#define TSR12        (*(volatile __near unsigned short *)0x1E4)
#define TSR12L       (*(volatile __near unsigned char  *)0x1E4)
#define TSR13        (*(volatile __near unsigned short *)0x1E6)
#define TSR13L       (*(volatile __near unsigned char  *)0x1E6)
#define TE1          (*(volatile __near unsigned short *)0x1F0)
#define TE1L         (*(volatile __near unsigned char  *)0x1F0)
#define TE1L_bit     (*(volatile __near __bitf_T *)0x1F0)
#define TS1          (*(volatile __near unsigned short *)0x1F2)
#define TS1L         (*(volatile __near unsigned char  *)0x1F2)
#define TS1L_bit     (*(volatile __near __bitf_T *)0x1F2)
#define TT1          (*(volatile __near unsigned short *)0x1F4)
#define TT1L         (*(volatile __near unsigned char  *)0x1F4)
#define TT1L_bit     (*(volatile __near __bitf_T *)0x1F4)
#define TPS1         (*(volatile __near unsigned short *)0x1F6)
#define TO1          (*(volatile __near unsigned short *)0x1F8)
#define TO1L         (*(volatile __near unsigned char  *)0x1F8)
#define TOE1         (*(volatile __near unsigned short *)0x1FA)
#define TOE1L        (*(volatile __near unsigned char  *)0x1FA)
#define TOE1L_bit    (*(volatile __near __bitf_T *)0x1FA)
#define TOL1         (*(volatile __near unsigned short *)0x1FC)
#define TOL1L        (*(volatile __near unsigned char  *)0x1FC)
#define TOM1         (*(volatile __near unsigned short *)0x1FE)
#define TOM1L        (*(volatile __near unsigned char  *)0x1FE)
#define IICCTL00     (*(volatile __near unsigned char  *)0x230)
#define IICCTL00_bit (*(volatile __near __bitf_T *)0x230)
#define SPT0         (((volatile __near __bitf_T *)0x230)->no0)
#define STT0         (((volatile __near __bitf_T *)0x230)->no1)
#define ACKE0        (((volatile __near __bitf_T *)0x230)->no2)
#define WTIM0        (((volatile __near __bitf_T *)0x230)->no3)
#define SPIE0        (((volatile __near __bitf_T *)0x230)->no4)
#define WREL0        (((volatile __near __bitf_T *)0x230)->no5)
#define LREL0        (((volatile __near __bitf_T *)0x230)->no6)
#define IICE0        (((volatile __near __bitf_T *)0x230)->no7)
#define IICCTL01     (*(volatile __near unsigned char  *)0x231)
#define IICCTL01_bit (*(volatile __near __bitf_T *)0x231)
#define PRS0         (((volatile __near __bitf_T *)0x231)->no0)
#define DFC0         (((volatile __near __bitf_T *)0x231)->no2)
#define SMC0         (((volatile __near __bitf_T *)0x231)->no3)
#define DAD0         (((volatile __near __bitf_T *)0x231)->no4)
#define CLD0         (((volatile __near __bitf_T *)0x231)->no5)
#define WUP0         (((volatile __near __bitf_T *)0x231)->no7)
#define IICWL0       (*(volatile __near unsigned char  *)0x232)
#define IICWH0       (*(volatile __near unsigned char  *)0x233)
#define SVA0         (*(volatile __near unsigned char  *)0x234)
#define IICCTL10     (*(volatile __near unsigned char  *)0x238)
#define IICCTL10_bit (*(volatile __near __bitf_T *)0x238)
#define SPT1         (((volatile __near __bitf_T *)0x238)->no0)
#define STT1         (((volatile __near __bitf_T *)0x238)->no1)
#define ACKE1        (((volatile __near __bitf_T *)0x238)->no2)
#define WTIM1        (((volatile __near __bitf_T *)0x238)->no3)
#define SPIE1        (((volatile __near __bitf_T *)0x238)->no4)
#define WREL1        (((volatile __near __bitf_T *)0x238)->no5)
#define LREL1        (((volatile __near __bitf_T *)0x238)->no6)
#define IICE1        (((volatile __near __bitf_T *)0x238)->no7)
#define IICCTL11     (*(volatile __near unsigned char  *)0x239)
#define IICCTL11_bit (*(volatile __near __bitf_T *)0x239)
#define PRS1         (((volatile __near __bitf_T *)0x239)->no0)
#define DFC1         (((volatile __near __bitf_T *)0x239)->no2)
#define SMC1         (((volatile __near __bitf_T *)0x239)->no3)
#define DAD1         (((volatile __near __bitf_T *)0x239)->no4)
#define CLD1         (((volatile __near __bitf_T *)0x239)->no5)
#define WUP1         (((volatile __near __bitf_T *)0x239)->no7)
#define IICWL1       (*(volatile __near unsigned char  *)0x23A)
#define IICWH1       (*(volatile __near unsigned char  *)0x23B)
#define SVA1         (*(volatile __near unsigned char  *)0x23C)
#define TRJCR0       (*(volatile __near unsigned char  *)0x240)
#define TRJIOC0      (*(volatile __near unsigned char  *)0x241)
#define TRJIOC0_bit  (*(volatile __near __bitf_T *)0x241)
#define TRJMR0       (*(volatile __near unsigned char  *)0x242)
#define TRJMR0_bit   (*(volatile __near __bitf_T *)0x242)
#define TRJISR0      (*(volatile __near unsigned char  *)0x243)
#define TRJISR0_bit  (*(volatile __near __bitf_T *)0x243)
#define TRGMR        (*(volatile __near unsigned char  *)0x250)
#define TRGMR_bit    (*(volatile __near __bitf_T *)0x250)
#define TRGPWM       (((volatile __near __bitf_T *)0x250)->no0)
#define TRGMDF       (((volatile __near __bitf_T *)0x250)->no1)
#define TRGDFA       (((volatile __near __bitf_T *)0x250)->no2)
#define TRGDFB       (((volatile __near __bitf_T *)0x250)->no3)
#define TRGDFCK0     (((volatile __near __bitf_T *)0x250)->no4)
#define TRGDFCK1     (((volatile __near __bitf_T *)0x250)->no5)
#define TRGELCICE    (((volatile __near __bitf_T *)0x250)->no6)
#define TRGSTART     (((volatile __near __bitf_T *)0x250)->no7)
#define TRGCNTC      (*(volatile __near unsigned char  *)0x251)
#define TRGCNTC_bit  (*(volatile __near __bitf_T *)0x251)
#define TRGCR        (*(volatile __near unsigned char  *)0x252)
#define TRGCR_bit    (*(volatile __near __bitf_T *)0x252)
#define TRGTCK0      (((volatile __near __bitf_T *)0x252)->no0)
#define TRGTCK1      (((volatile __near __bitf_T *)0x252)->no1)
#define TRGTCK2      (((volatile __near __bitf_T *)0x252)->no2)
#define TRGCKEG0     (((volatile __near __bitf_T *)0x252)->no3)
#define TRGCKEG1     (((volatile __near __bitf_T *)0x252)->no4)
#define TRGCCLR0     (((volatile __near __bitf_T *)0x252)->no5)
#define TRGCCLR1     (((volatile __near __bitf_T *)0x252)->no6)
#define TRGIER       (*(volatile __near unsigned char  *)0x253)
#define TRGIER_bit   (*(volatile __near __bitf_T *)0x253)
#define TRGIMIEA     (((volatile __near __bitf_T *)0x253)->no0)
#define TRGIMIEB     (((volatile __near __bitf_T *)0x253)->no1)
#define TRGUDIE      (((volatile __near __bitf_T *)0x253)->no2)
#define TRGOVIE      (((volatile __near __bitf_T *)0x253)->no3)
#define TRGSR        (*(volatile __near unsigned char  *)0x254)
#define TRGSR_bit    (*(volatile __near __bitf_T *)0x254)
#define TRGIMFA      (((volatile __near __bitf_T *)0x254)->no0)
#define TRGIMFB      (((volatile __near __bitf_T *)0x254)->no1)
#define TRGUDF       (((volatile __near __bitf_T *)0x254)->no2)
#define TRGOVF       (((volatile __near __bitf_T *)0x254)->no3)
#define TRGDIRF      (((volatile __near __bitf_T *)0x254)->no4)
#define TRGIOR       (*(volatile __near unsigned char  *)0x255)
#define TRGIOR_bit   (*(volatile __near __bitf_T *)0x255)
#define TRGIOA0      (((volatile __near __bitf_T *)0x255)->no0)
#define TRGIOA1      (((volatile __near __bitf_T *)0x255)->no1)
#define TRGIOA2      (((volatile __near __bitf_T *)0x255)->no2)
#define TRGBUFA      (((volatile __near __bitf_T *)0x255)->no3)
#define TRGIOB0      (((volatile __near __bitf_T *)0x255)->no4)
#define TRGIOB1      (((volatile __near __bitf_T *)0x255)->no5)
#define TRGIOB2      (((volatile __near __bitf_T *)0x255)->no6)
#define TRGBUFB      (((volatile __near __bitf_T *)0x255)->no7)
#define TRG          (*(volatile __near unsigned short *)0x256)
#define TRGGRA       (*(volatile __near unsigned short *)0x258)
#define TRGGRB       (*(volatile __near unsigned short *)0x25A)
#define TRDELC       (*(volatile __near unsigned char  *)0x260)
#define TRDELC_bit   (*(volatile __near __bitf_T *)0x260)
#define TRDSTR       (*(volatile __near unsigned char  *)0x263)
#define TRDMR        (*(volatile __near unsigned char  *)0x264)
#define TRDMR_bit    (*(volatile __near __bitf_T *)0x264)
#define TRDSYNC      (((volatile __near __bitf_T *)0x264)->no0)
#define TRDBFC0      (((volatile __near __bitf_T *)0x264)->no4)
#define TRDBFD0      (((volatile __near __bitf_T *)0x264)->no5)
#define TRDBFC1      (((volatile __near __bitf_T *)0x264)->no6)
#define TRDBFD1      (((volatile __near __bitf_T *)0x264)->no7)
#define TRDPMR       (*(volatile __near unsigned char  *)0x265)
#define TRDPMR_bit   (*(volatile __near __bitf_T *)0x265)
#define TRDPWMB0     (((volatile __near __bitf_T *)0x265)->no0)
#define TRDPWMC0     (((volatile __near __bitf_T *)0x265)->no1)
#define TRDPWMD0     (((volatile __near __bitf_T *)0x265)->no2)
#define TRDPWMB1     (((volatile __near __bitf_T *)0x265)->no4)
#define TRDPWMC1     (((volatile __near __bitf_T *)0x265)->no5)
#define TRDPWMD1     (((volatile __near __bitf_T *)0x265)->no6)
#define TRDFCR       (*(volatile __near unsigned char  *)0x266)
#define TRDFCR_bit   (*(volatile __near __bitf_T *)0x266)
#define TRDOER1      (*(volatile __near unsigned char  *)0x267)
#define TRDOER1_bit  (*(volatile __near __bitf_T *)0x267)
#define TRDOER2      (*(volatile __near unsigned char  *)0x268)
#define TRDOER2_bit  (*(volatile __near __bitf_T *)0x268)
#define TRDSHUTS     (((volatile __near __bitf_T *)0x268)->no0)
#define TRDPTO       (((volatile __near __bitf_T *)0x268)->no7)
#define TRDOCR       (*(volatile __near unsigned char  *)0x269)
#define TRDOCR_bit   (*(volatile __near __bitf_T *)0x269)
#define TRDDF0       (*(volatile __near unsigned char  *)0x26A)
#define TRDDF0_bit   (*(volatile __near __bitf_T *)0x26A)
#define TRDDF1       (*(volatile __near unsigned char  *)0x26B)
#define TRDDF1_bit   (*(volatile __near __bitf_T *)0x26B)
#define TRDCR0       (*(volatile __near unsigned char  *)0x270)
#define TRDCR0_bit   (*(volatile __near __bitf_T *)0x270)
#define TRDIORA0     (*(volatile __near unsigned char  *)0x271)
#define TRDIORA0_bit (*(volatile __near __bitf_T *)0x271)
#define TRDIORC0     (*(volatile __near unsigned char  *)0x272)
#define TRDIORC0_bit (*(volatile __near __bitf_T *)0x272)
#define TRDSR0       (*(volatile __near unsigned char  *)0x273)
#define TRDSR0_bit   (*(volatile __near __bitf_T *)0x273)
#define TRDIER0      (*(volatile __near unsigned char  *)0x274)
#define TRDIER0_bit  (*(volatile __near __bitf_T *)0x274)
#define TRDPOCR0     (*(volatile __near unsigned char  *)0x275)
#define TRDPOCR0_bit (*(volatile __near __bitf_T *)0x275)
#define TRD0         (*(volatile __near unsigned short *)0x276)
#define TRDGRA0      (*(volatile __near unsigned short *)0x278)
#define TRDGRB0      (*(volatile __near unsigned short *)0x27A)
#define TRDCR1       (*(volatile __near unsigned char  *)0x280)
#define TRDCR1_bit   (*(volatile __near __bitf_T *)0x280)
#define TRDIORA1     (*(volatile __near unsigned char  *)0x281)
#define TRDIORA1_bit (*(volatile __near __bitf_T *)0x281)
#define TRDIORC1     (*(volatile __near unsigned char  *)0x282)
#define TRDIORC1_bit (*(volatile __near __bitf_T *)0x282)
#define TRDSR1       (*(volatile __near unsigned char  *)0x283)
#define TRDSR1_bit   (*(volatile __near __bitf_T *)0x283)
#define TRDIER1      (*(volatile __near unsigned char  *)0x284)
#define TRDIER1_bit  (*(volatile __near __bitf_T *)0x284)
#define TRDPOCR1     (*(volatile __near unsigned char  *)0x285)
#define TRDPOCR1_bit (*(volatile __near __bitf_T *)0x285)
#define TRD1         (*(volatile __near unsigned short *)0x286)
#define TRDGRA1      (*(volatile __near unsigned short *)0x288)
#define TRDGRB1      (*(volatile __near unsigned short *)0x28A)
#define DTCBAR       (*(volatile __near unsigned char  *)0x2E0)
#define DTCEN0       (*(volatile __near unsigned char  *)0x2E8)
#define DTCEN0_bit   (*(volatile __near __bitf_T *)0x2E8)
#define DTCEN1       (*(volatile __near unsigned char  *)0x2E9)
#define DTCEN1_bit   (*(volatile __near __bitf_T *)0x2E9)
#define DTCEN2       (*(volatile __near unsigned char  *)0x2EA)
#define DTCEN2_bit   (*(volatile __near __bitf_T *)0x2EA)
#define DTCEN3       (*(volatile __near unsigned char  *)0x2EB)
#define DTCEN3_bit   (*(volatile __near __bitf_T *)0x2EB)
#define DTCEN4       (*(volatile __near unsigned char  *)0x2EC)
#define DTCEN4_bit   (*(volatile __near __bitf_T *)0x2EC)
#define CRC0CTL      (*(volatile __near unsigned char  *)0x2F0)
#define CRC0CTL_bit  (*(volatile __near __bitf_T *)0x2F0)
#define CRC0EN       (((volatile __near __bitf_T *)0x2F0)->no7)
#define PGCRCL       (*(volatile __near unsigned short *)0x2F2)
#define CRCD         (*(volatile __near unsigned short *)0x2FA)
#define ELSELR00     (*(volatile __near unsigned char  *)0x300)
#define ELSELR01     (*(volatile __near unsigned char  *)0x301)
#define ELSELR02     (*(volatile __near unsigned char  *)0x302)
#define ELSELR03     (*(volatile __near unsigned char  *)0x303)
#define ELSELR04     (*(volatile __near unsigned char  *)0x304)
#define ELSELR05     (*(volatile __near unsigned char  *)0x305)
#define ELSELR06     (*(volatile __near unsigned char  *)0x306)
#define ELSELR07     (*(volatile __near unsigned char  *)0x307)
#define ELSELR08     (*(volatile __near unsigned char  *)0x308)
#define ELSELR09     (*(volatile __near unsigned char  *)0x309)
#define ELSELR10     (*(volatile __near unsigned char  *)0x30A)
#define ELSELR11     (*(volatile __near unsigned char  *)0x30B)
#define ELSELR12     (*(volatile __near unsigned char  *)0x30C)
#define ELSELR13     (*(volatile __near unsigned char  *)0x30D)
#define ELSELR14     (*(volatile __near unsigned char  *)0x30E)
#define ELSELR15     (*(volatile __near unsigned char  *)0x30F)
#define ELSELR16     (*(volatile __near unsigned char  *)0x310)
#define ELSELR17     (*(volatile __near unsigned char  *)0x311)
#define ELSELR18     (*(volatile __near unsigned char  *)0x312)
#define ELSELR19     (*(volatile __near unsigned char  *)0x313)
#define ELSELR20     (*(volatile __near unsigned char  *)0x314)
#define ELSELR21     (*(volatile __near unsigned char  *)0x315)
#define ELSELR22     (*(volatile __near unsigned char  *)0x316)
#define ELSELR23     (*(volatile __near unsigned char  *)0x317)
#define ELSELR24     (*(volatile __near unsigned char  *)0x318)
#define ELSELR25     (*(volatile __near unsigned char  *)0x319)
#define COMPMDR      (*(volatile __near unsigned char  *)0x340)
#define COMPMDR_bit  (*(volatile __near __bitf_T *)0x340)
#define C0ENB        (((volatile __near __bitf_T *)0x340)->no0)
#define C0MON        (((volatile __near __bitf_T *)0x340)->no3)
#define C1ENB        (((volatile __near __bitf_T *)0x340)->no4)
#define C1MON        (((volatile __near __bitf_T *)0x340)->no7)
#define COMPFIR      (*(volatile __near unsigned char  *)0x341)
#define COMPFIR_bit  (*(volatile __near __bitf_T *)0x341)
#define COMPOCR      (*(volatile __near unsigned char  *)0x342)
#define COMPOCR_bit  (*(volatile __near __bitf_T *)0x342)
#define C0IE         (((volatile __near __bitf_T *)0x342)->no0)
#define C0OE         (((volatile __near __bitf_T *)0x342)->no1)
#define C0OP         (((volatile __near __bitf_T *)0x342)->no2)
#define C1IE         (((volatile __near __bitf_T *)0x342)->no4)
#define C1OE         (((volatile __near __bitf_T *)0x342)->no5)
#define C1OP         (((volatile __near __bitf_T *)0x342)->no6)
#define SPDMD        (((volatile __near __bitf_T *)0x342)->no7)
#define TRJ0         (*(volatile __near unsigned short *)0x500)
#define P0           (*(volatile __near unsigned char  *)0xFF00)
#define P0_bit       (*(volatile __near __bitf_T *)0xFF00)
#define P1           (*(volatile __near unsigned char  *)0xFF01)
#define P1_bit       (*(volatile __near __bitf_T *)0xFF01)
#define P2           (*(volatile __near unsigned char  *)0xFF02)
#define P2_bit       (*(volatile __near __bitf_T *)0xFF02)
#define P3           (*(volatile __near unsigned char  *)0xFF03)
#define P3_bit       (*(volatile __near __bitf_T *)0xFF03)
#define P4           (*(volatile __near unsigned char  *)0xFF04)
#define P4_bit       (*(volatile __near __bitf_T *)0xFF04)
#define P5           (*(volatile __near unsigned char  *)0xFF05)
#define P5_bit       (*(volatile __near __bitf_T *)0xFF05)
#define P6           (*(volatile __near unsigned char  *)0xFF06)
#define P6_bit       (*(volatile __near __bitf_T *)0xFF06)
#define P7           (*(volatile __near unsigned char  *)0xFF07)
#define P7_bit       (*(volatile __near __bitf_T *)0xFF07)
#define P10          (*(volatile __near unsigned char  *)0xFF0A)
#define P10_bit      (*(volatile __near __bitf_T *)0xFF0A)
#define P11          (*(volatile __near unsigned char  *)0xFF0B)
#define P11_bit      (*(volatile __near __bitf_T *)0xFF0B)
#define P12          (*(volatile __near unsigned char  *)0xFF0C)
#define P12_bit      (*(volatile __near __bitf_T *)0xFF0C)
#define P13          (*(volatile __near unsigned char  *)0xFF0D)
#define P13_bit      (*(volatile __near __bitf_T *)0xFF0D)
#define P14          (*(volatile __near unsigned char  *)0xFF0E)
#define P14_bit      (*(volatile __near __bitf_T *)0xFF0E)
#define P15          (*(volatile __near unsigned char  *)0xFF0F)
#define P15_bit      (*(volatile __near __bitf_T *)0xFF0F)
#define SDR00        (*(volatile __near unsigned short *)0xFF10)
#define SIO00        (*(volatile __near unsigned char  *)0xFF10)
#define TXD0         (*(volatile __near unsigned char  *)0xFF10)
#define SDR01        (*(volatile __near unsigned short *)0xFF12)
#define RXD0         (*(volatile __near unsigned char  *)0xFF12)
#define SIO01        (*(volatile __near unsigned char  *)0xFF12)
#define SDR12        (*(volatile __near unsigned short *)0xFF14)
#define SIO30        (*(volatile __near unsigned char  *)0xFF14)
#define TXD3         (*(volatile __near unsigned char  *)0xFF14)
#define SDR13        (*(volatile __near unsigned short *)0xFF16)
#define RXD3         (*(volatile __near unsigned char  *)0xFF16)
#define SIO31        (*(volatile __near unsigned char  *)0xFF16)
#define TDR00        (*(volatile __near unsigned short *)0xFF18)
#define TDR01        (*(volatile __near unsigned short *)0xFF1A)
#define TDR01L       (*(volatile __near unsigned char  *)0xFF1A)
#define TDR01H       (*(volatile __near unsigned char  *)0xFF1B)
#define ADCR         (*(volatile __near unsigned short *)0xFF1E)
#define ADCRH        (*(volatile __near unsigned char  *)0xFF1F)
#define PM0          (*(volatile __near unsigned char  *)0xFF20)
#define PM0_bit      (*(volatile __near __bitf_T *)0xFF20)
#define PM1          (*(volatile __near unsigned char  *)0xFF21)
#define PM1_bit      (*(volatile __near __bitf_T *)0xFF21)
#define PM2          (*(volatile __near unsigned char  *)0xFF22)
#define PM2_bit      (*(volatile __near __bitf_T *)0xFF22)
#define PM3          (*(volatile __near unsigned char  *)0xFF23)
#define PM3_bit      (*(volatile __near __bitf_T *)0xFF23)
#define PM4          (*(volatile __near unsigned char  *)0xFF24)
#define PM4_bit      (*(volatile __near __bitf_T *)0xFF24)
#define PM5          (*(volatile __near unsigned char  *)0xFF25)
#define PM5_bit      (*(volatile __near __bitf_T *)0xFF25)
#define PM6          (*(volatile __near unsigned char  *)0xFF26)
#define PM6_bit      (*(volatile __near __bitf_T *)0xFF26)
#define PM7          (*(volatile __near unsigned char  *)0xFF27)
#define PM7_bit      (*(volatile __near __bitf_T *)0xFF27)
#define PM10         (*(volatile __near unsigned char  *)0xFF2A)
#define PM10_bit     (*(volatile __near __bitf_T *)0xFF2A)
#define PM11         (*(volatile __near unsigned char  *)0xFF2B)
#define PM11_bit     (*(volatile __near __bitf_T *)0xFF2B)
#define PM12         (*(volatile __near unsigned char  *)0xFF2C)
#define PM12_bit     (*(volatile __near __bitf_T *)0xFF2C)
#define PM14         (*(volatile __near unsigned char  *)0xFF2E)
#define PM14_bit     (*(volatile __near __bitf_T *)0xFF2E)
#define PM15         (*(volatile __near unsigned char  *)0xFF2F)
#define PM15_bit     (*(volatile __near __bitf_T *)0xFF2F)
#define ADM0         (*(volatile __near unsigned char  *)0xFF30)
#define ADM0_bit     (*(volatile __near __bitf_T *)0xFF30)
#define ADCE         (((volatile __near __bitf_T *)0xFF30)->no0)
#define ADCS         (((volatile __near __bitf_T *)0xFF30)->no7)
#define ADS          (*(volatile __near unsigned char  *)0xFF31)
#define ADS_bit      (*(volatile __near __bitf_T *)0xFF31)
#define ADM1         (*(volatile __near unsigned char  *)0xFF32)
#define ADM1_bit     (*(volatile __near __bitf_T *)0xFF32)
#define DACS0        (*(volatile __near unsigned char  *)0xFF34)
#define DACS1        (*(volatile __near unsigned char  *)0xFF35)
#define DAM          (*(volatile __near unsigned char  *)0xFF36)
#define DAM_bit      (*(volatile __near __bitf_T *)0xFF36)
#define DACE0        (((volatile __near __bitf_T *)0xFF36)->no4)
#define DACE1        (((volatile __near __bitf_T *)0xFF36)->no5)
#define KRM          (*(volatile __near unsigned char  *)0xFF37)
#define KRM_bit      (*(volatile __near __bitf_T *)0xFF37)
#define EGP0         (*(volatile __near unsigned char  *)0xFF38)
#define EGP0_bit     (*(volatile __near __bitf_T *)0xFF38)
#define EGN0         (*(volatile __near unsigned char  *)0xFF39)
#define EGN0_bit     (*(volatile __near __bitf_T *)0xFF39)
#define EGP1         (*(volatile __near unsigned char  *)0xFF3A)
#define EGP1_bit     (*(volatile __near __bitf_T *)0xFF3A)
#define EGN1         (*(volatile __near unsigned char  *)0xFF3B)
#define EGN1_bit     (*(volatile __near __bitf_T *)0xFF3B)
#define SDR02        (*(volatile __near unsigned short *)0xFF44)
#define SIO10        (*(volatile __near unsigned char  *)0xFF44)
#define TXD1         (*(volatile __near unsigned char  *)0xFF44)
#define SDR03        (*(volatile __near unsigned short *)0xFF46)
#define RXD1         (*(volatile __near unsigned char  *)0xFF46)
#define SIO11        (*(volatile __near unsigned char  *)0xFF46)
#define SDR10        (*(volatile __near unsigned short *)0xFF48)
#define SIO20        (*(volatile __near unsigned char  *)0xFF48)
#define TXD2         (*(volatile __near unsigned char  *)0xFF48)
#define SDR11        (*(volatile __near unsigned short *)0xFF4A)
#define RXD2         (*(volatile __near unsigned char  *)0xFF4A)
#define SIO21        (*(volatile __near unsigned char  *)0xFF4A)
#define IICA0        (*(volatile __near unsigned char  *)0xFF50)
#define IICS0        (*(volatile __near unsigned char  *)0xFF51)
#define IICS0_bit    (*(volatile __near __bitf_T *)0xFF51)
#define SPD0         (((volatile __near __bitf_T *)0xFF51)->no0)
#define STD0         (((volatile __near __bitf_T *)0xFF51)->no1)
#define ACKD0        (((volatile __near __bitf_T *)0xFF51)->no2)
#define TRC0         (((volatile __near __bitf_T *)0xFF51)->no3)
#define COI0         (((volatile __near __bitf_T *)0xFF51)->no4)
#define EXC0         (((volatile __near __bitf_T *)0xFF51)->no5)
#define ALD0         (((volatile __near __bitf_T *)0xFF51)->no6)
#define MSTS0        (((volatile __near __bitf_T *)0xFF51)->no7)
#define IICF0        (*(volatile __near unsigned char  *)0xFF52)
#define IICF0_bit    (*(volatile __near __bitf_T *)0xFF52)
#define IICRSV0      (((volatile __near __bitf_T *)0xFF52)->no0)
#define STCEN0       (((volatile __near __bitf_T *)0xFF52)->no1)
#define IICBSY0      (((volatile __near __bitf_T *)0xFF52)->no6)
#define STCF0        (((volatile __near __bitf_T *)0xFF52)->no7)
#define IICA1        (*(volatile __near unsigned char  *)0xFF54)
#define IICS1        (*(volatile __near unsigned char  *)0xFF55)
#define IICS1_bit    (*(volatile __near __bitf_T *)0xFF55)
#define SPD1         (((volatile __near __bitf_T *)0xFF55)->no0)
#define STD1         (((volatile __near __bitf_T *)0xFF55)->no1)
#define ACKD1        (((volatile __near __bitf_T *)0xFF55)->no2)
#define TRC1         (((volatile __near __bitf_T *)0xFF55)->no3)
#define COI1         (((volatile __near __bitf_T *)0xFF55)->no4)
#define EXC1         (((volatile __near __bitf_T *)0xFF55)->no5)
#define ALD1         (((volatile __near __bitf_T *)0xFF55)->no6)
#define MSTS1        (((volatile __near __bitf_T *)0xFF55)->no7)
#define IICF1        (*(volatile __near unsigned char  *)0xFF56)
#define IICF1_bit    (*(volatile __near __bitf_T *)0xFF56)
#define IICRSV1      (((volatile __near __bitf_T *)0xFF56)->no0)
#define STCEN1       (((volatile __near __bitf_T *)0xFF56)->no1)
#define IICBSY1      (((volatile __near __bitf_T *)0xFF56)->no6)
#define STCF1        (((volatile __near __bitf_T *)0xFF56)->no7)
#define TRDGRC0      (*(volatile __near unsigned short *)0xFF58)
#define TRDGRD0      (*(volatile __near unsigned short *)0xFF5A)
#define TRDGRC1      (*(volatile __near unsigned short *)0xFF5C)
#define TRDGRD1      (*(volatile __near unsigned short *)0xFF5E)
#define TRGGRC       (*(volatile __near unsigned short *)0xFF60)
#define TRGGRD       (*(volatile __near unsigned short *)0xFF62)
#define TDR02        (*(volatile __near unsigned short *)0xFF64)
#define TDR03        (*(volatile __near unsigned short *)0xFF66)
#define TDR03L       (*(volatile __near unsigned char  *)0xFF66)
#define TDR03H       (*(volatile __near unsigned char  *)0xFF67)
#define TDR10        (*(volatile __near unsigned short *)0xFF70)
#define TDR11        (*(volatile __near unsigned short *)0xFF72)
#define TDR11L       (*(volatile __near unsigned char  *)0xFF72)
#define TDR11H       (*(volatile __near unsigned char  *)0xFF73)
#define TDR12        (*(volatile __near unsigned short *)0xFF74)
#define TDR13        (*(volatile __near unsigned short *)0xFF76)
#define TDR13L       (*(volatile __near unsigned char  *)0xFF76)
#define TDR13H       (*(volatile __near unsigned char  *)0xFF77)
#define ITMC         (*(volatile __near unsigned short *)0xFF90)
#define SEC          (*(volatile __near unsigned char  *)0xFF92)
#define MINUTE       (*(volatile __near unsigned char  *)0xFF93)
#define HOUR         (*(volatile __near unsigned char  *)0xFF94)
#define WEEK         (*(volatile __near unsigned char  *)0xFF95)
#define DAY          (*(volatile __near unsigned char  *)0xFF96)
#define MONTH        (*(volatile __near unsigned char  *)0xFF97)
#define YEAR         (*(volatile __near unsigned char  *)0xFF98)
#define SUBCUD       (*(volatile __near unsigned char  *)0xFF99)
#define ALARMWM      (*(volatile __near unsigned char  *)0xFF9A)
#define ALARMWH      (*(volatile __near unsigned char  *)0xFF9B)
#define ALARMWW      (*(volatile __near unsigned char  *)0xFF9C)
#define RTCC0        (*(volatile __near unsigned char  *)0xFF9D)
#define RTCC0_bit    (*(volatile __near __bitf_T *)0xFF9D)
#define RCLOE1       (((volatile __near __bitf_T *)0xFF9D)->no5)
#define RTCE         (((volatile __near __bitf_T *)0xFF9D)->no7)
#define RTCC1        (*(volatile __near unsigned char  *)0xFF9E)
#define RTCC1_bit    (*(volatile __near __bitf_T *)0xFF9E)
#define RWAIT        (((volatile __near __bitf_T *)0xFF9E)->no0)
#define RWST         (((volatile __near __bitf_T *)0xFF9E)->no1)
#define RIFG         (((volatile __near __bitf_T *)0xFF9E)->no3)
#define WAFG         (((volatile __near __bitf_T *)0xFF9E)->no4)
#define WALIE        (((volatile __near __bitf_T *)0xFF9E)->no6)
#define WALE         (((volatile __near __bitf_T *)0xFF9E)->no7)
#define CMC          (*(volatile __near unsigned char  *)0xFFA0)
#define CSC          (*(volatile __near unsigned char  *)0xFFA1)
#define CSC_bit      (*(volatile __near __bitf_T *)0xFFA1)
#define HIOSTOP      (((volatile __near __bitf_T *)0xFFA1)->no0)
#define XTSTOP       (((volatile __near __bitf_T *)0xFFA1)->no6)
#define MSTOP        (((volatile __near __bitf_T *)0xFFA1)->no7)
#define OSTC         (*(volatile __near unsigned char  *)0xFFA2)
#define OSTC_bit     (*(volatile __near __bitf_T *)0xFFA2)
#define OSTS         (*(volatile __near unsigned char  *)0xFFA3)
#define CKC          (*(volatile __near unsigned char  *)0xFFA4)
#define CKC_bit      (*(volatile __near __bitf_T *)0xFFA4)
#define MCM0         (((volatile __near __bitf_T *)0xFFA4)->no4)
#define MCS          (((volatile __near __bitf_T *)0xFFA4)->no5)
#define CSS          (((volatile __near __bitf_T *)0xFFA4)->no6)
#define CLS          (((volatile __near __bitf_T *)0xFFA4)->no7)
#define CKS0         (*(volatile __near unsigned char  *)0xFFA5)
#define CKS0_bit     (*(volatile __near __bitf_T *)0xFFA5)
#define PCLOE0       (((volatile __near __bitf_T *)0xFFA5)->no7)
#define CKS1         (*(volatile __near unsigned char  *)0xFFA6)
#define CKS1_bit     (*(volatile __near __bitf_T *)0xFFA6)
#define PCLOE1       (((volatile __near __bitf_T *)0xFFA6)->no7)
#define RESF         (*(volatile __near unsigned char  *)0xFFA8)
#define LVIM         (*(volatile __near unsigned char  *)0xFFA9)
#define LVIM_bit     (*(volatile __near __bitf_T *)0xFFA9)
#define LVIF         (((volatile __near __bitf_T *)0xFFA9)->no0)
#define LVIOMSK      (((volatile __near __bitf_T *)0xFFA9)->no1)
#define LVISEN       (((volatile __near __bitf_T *)0xFFA9)->no7)
#define LVIS         (*(volatile __near unsigned char  *)0xFFAA)
#define LVIS_bit     (*(volatile __near __bitf_T *)0xFFAA)
#define LVILV        (((volatile __near __bitf_T *)0xFFAA)->no0)
#define LVIMD        (((volatile __near __bitf_T *)0xFFAA)->no7)
#define WDTE         (*(volatile __near unsigned char  *)0xFFAB)
#define CRCIN        (*(volatile __near unsigned char  *)0xFFAC)
#define IF2          (*(volatile __near unsigned short *)0xFFD0)
#define IF2L         (*(volatile __near unsigned char  *)0xFFD0)
#define IF2L_bit     (*(volatile __near __bitf_T *)0xFFD0)
#define IF2H         (*(volatile __near unsigned char  *)0xFFD1)
#define IF2H_bit     (*(volatile __near __bitf_T *)0xFFD1)
#define TMIF11       (((volatile __near __bitf_T *)0xFFD0)->no0)
#define TMIF12       (((volatile __near __bitf_T *)0xFFD0)->no1)
#define TMIF13       (((volatile __near __bitf_T *)0xFFD0)->no2)
#define PIF6         (((volatile __near __bitf_T *)0xFFD0)->no3)
#define PIF7         (((volatile __near __bitf_T *)0xFFD0)->no4)
#define PIF8         (((volatile __near __bitf_T *)0xFFD0)->no5)
#define PIF9         (((volatile __near __bitf_T *)0xFFD0)->no6)
#define CMPIF0       (((volatile __near __bitf_T *)0xFFD0)->no7)
#define PIF10        (((volatile __near __bitf_T *)0xFFD0)->no7)
#define CMPIF1       (((volatile __near __bitf_T *)0xFFD1)->no0)
#define PIF11        (((volatile __near __bitf_T *)0xFFD1)->no0)
#define TRDIF0       (((volatile __near __bitf_T *)0xFFD1)->no1)
#define TRDIF1       (((volatile __near __bitf_T *)0xFFD1)->no2)
#define TRGIF        (((volatile __near __bitf_T *)0xFFD1)->no3)
#define SREIF3       (((volatile __near __bitf_T *)0xFFD1)->no4)
#define TMIF13H      (((volatile __near __bitf_T *)0xFFD1)->no4)
#define IICAIF1      (((volatile __near __bitf_T *)0xFFD1)->no6)
#define FLIF         (((volatile __near __bitf_T *)0xFFD1)->no7)
#define MK2          (*(volatile __near unsigned short *)0xFFD4)
#define MK2L         (*(volatile __near unsigned char  *)0xFFD4)
#define MK2L_bit     (*(volatile __near __bitf_T *)0xFFD4)
#define MK2H         (*(volatile __near unsigned char  *)0xFFD5)
#define MK2H_bit     (*(volatile __near __bitf_T *)0xFFD5)
#define TMMK11       (((volatile __near __bitf_T *)0xFFD4)->no0)
#define TMMK12       (((volatile __near __bitf_T *)0xFFD4)->no1)
#define TMMK13       (((volatile __near __bitf_T *)0xFFD4)->no2)
#define PMK6         (((volatile __near __bitf_T *)0xFFD4)->no3)
#define PMK7         (((volatile __near __bitf_T *)0xFFD4)->no4)
#define PMK8         (((volatile __near __bitf_T *)0xFFD4)->no5)
#define PMK9         (((volatile __near __bitf_T *)0xFFD4)->no6)
#define CMPMK0       (((volatile __near __bitf_T *)0xFFD4)->no7)
#define PMK10        (((volatile __near __bitf_T *)0xFFD4)->no7)
#define CMPMK1       (((volatile __near __bitf_T *)0xFFD5)->no0)
#define PMK11        (((volatile __near __bitf_T *)0xFFD5)->no0)
#define TRDMK0       (((volatile __near __bitf_T *)0xFFD5)->no1)
#define TRDMK1       (((volatile __near __bitf_T *)0xFFD5)->no2)
#define TRGMK        (((volatile __near __bitf_T *)0xFFD5)->no3)
#define SREMK3       (((volatile __near __bitf_T *)0xFFD5)->no4)
#define TMMK13H      (((volatile __near __bitf_T *)0xFFD5)->no4)
#define IICAMK1      (((volatile __near __bitf_T *)0xFFD5)->no6)
#define FLMK         (((volatile __near __bitf_T *)0xFFD5)->no7)
#define PR02         (*(volatile __near unsigned short *)0xFFD8)
#define PR02L        (*(volatile __near unsigned char  *)0xFFD8)
#define PR02L_bit    (*(volatile __near __bitf_T *)0xFFD8)
#define PR02H        (*(volatile __near unsigned char  *)0xFFD9)
#define PR02H_bit    (*(volatile __near __bitf_T *)0xFFD9)
#define TMPR011      (((volatile __near __bitf_T *)0xFFD8)->no0)
#define TMPR012      (((volatile __near __bitf_T *)0xFFD8)->no1)
#define TMPR013      (((volatile __near __bitf_T *)0xFFD8)->no2)
#define PPR06        (((volatile __near __bitf_T *)0xFFD8)->no3)
#define PPR07        (((volatile __near __bitf_T *)0xFFD8)->no4)
#define PPR08        (((volatile __near __bitf_T *)0xFFD8)->no5)
#define PPR09        (((volatile __near __bitf_T *)0xFFD8)->no6)
#define CMPPR00      (((volatile __near __bitf_T *)0xFFD8)->no7)
#define PPR010       (((volatile __near __bitf_T *)0xFFD8)->no7)
#define CMPPR01      (((volatile __near __bitf_T *)0xFFD9)->no0)
#define PPR011       (((volatile __near __bitf_T *)0xFFD9)->no0)
#define TRDPR00      (((volatile __near __bitf_T *)0xFFD9)->no1)
#define TRDPR01      (((volatile __near __bitf_T *)0xFFD9)->no2)
#define TRGPR0       (((volatile __near __bitf_T *)0xFFD9)->no3)
#define SREPR03      (((volatile __near __bitf_T *)0xFFD9)->no4)
#define TMPR013H     (((volatile __near __bitf_T *)0xFFD9)->no4)
#define IICAPR01     (((volatile __near __bitf_T *)0xFFD9)->no6)
#define FLPR0        (((volatile __near __bitf_T *)0xFFD9)->no7)
#define PR12         (*(volatile __near unsigned short *)0xFFDC)
#define PR12L        (*(volatile __near unsigned char  *)0xFFDC)
#define PR12L_bit    (*(volatile __near __bitf_T *)0xFFDC)
#define PR12H        (*(volatile __near unsigned char  *)0xFFDD)
#define PR12H_bit    (*(volatile __near __bitf_T *)0xFFDD)
#define TMPR111      (((volatile __near __bitf_T *)0xFFDC)->no0)
#define TMPR112      (((volatile __near __bitf_T *)0xFFDC)->no1)
#define TMPR113      (((volatile __near __bitf_T *)0xFFDC)->no2)
#define PPR16        (((volatile __near __bitf_T *)0xFFDC)->no3)
#define PPR17        (((volatile __near __bitf_T *)0xFFDC)->no4)
#define PPR18        (((volatile __near __bitf_T *)0xFFDC)->no5)
#define PPR19        (((volatile __near __bitf_T *)0xFFDC)->no6)
#define CMPPR10      (((volatile __near __bitf_T *)0xFFDC)->no7)
#define PPR110       (((volatile __near __bitf_T *)0xFFDC)->no7)
#define CMPPR11      (((volatile __near __bitf_T *)0xFFDD)->no0)
#define PPR111       (((volatile __near __bitf_T *)0xFFDD)->no0)
#define TRDPR10      (((volatile __near __bitf_T *)0xFFDD)->no1)
#define TRDPR11      (((volatile __near __bitf_T *)0xFFDD)->no2)
#define TRGPR1       (((volatile __near __bitf_T *)0xFFDD)->no3)
#define SREPR13      (((volatile __near __bitf_T *)0xFFDD)->no4)
#define TMPR113H     (((volatile __near __bitf_T *)0xFFDD)->no4)
#define IICAPR11     (((volatile __near __bitf_T *)0xFFDD)->no6)
#define FLPR1        (((volatile __near __bitf_T *)0xFFDD)->no7)
#define IF0          (*(volatile __near unsigned short *)0xFFE0)
#define IF0L         (*(volatile __near unsigned char  *)0xFFE0)
#define IF0L_bit     (*(volatile __near __bitf_T *)0xFFE0)
#define IF0H         (*(volatile __near unsigned char  *)0xFFE1)
#define IF0H_bit     (*(volatile __near __bitf_T *)0xFFE1)
#define WDTIIF       (((volatile __near __bitf_T *)0xFFE0)->no0)
#define LVIIF        (((volatile __near __bitf_T *)0xFFE0)->no1)
#define PIF0         (((volatile __near __bitf_T *)0xFFE0)->no2)
#define PIF1         (((volatile __near __bitf_T *)0xFFE0)->no3)
#define PIF2         (((volatile __near __bitf_T *)0xFFE0)->no4)
#define PIF3         (((volatile __near __bitf_T *)0xFFE0)->no5)
#define PIF4         (((volatile __near __bitf_T *)0xFFE0)->no6)
#define PIF5         (((volatile __near __bitf_T *)0xFFE0)->no7)
#define CSIIF20      (((volatile __near __bitf_T *)0xFFE1)->no0)
#define IICIF20      (((volatile __near __bitf_T *)0xFFE1)->no0)
#define STIF2        (((volatile __near __bitf_T *)0xFFE1)->no0)
#define CSIIF21      (((volatile __near __bitf_T *)0xFFE1)->no1)
#define IICIF21      (((volatile __near __bitf_T *)0xFFE1)->no1)
#define SRIF2        (((volatile __near __bitf_T *)0xFFE1)->no1)
#define SREIF2       (((volatile __near __bitf_T *)0xFFE1)->no2)
#define TMIF11H      (((volatile __near __bitf_T *)0xFFE1)->no2)
#define CSIIF00      (((volatile __near __bitf_T *)0xFFE1)->no5)
#define IICIF00      (((volatile __near __bitf_T *)0xFFE1)->no5)
#define STIF0        (((volatile __near __bitf_T *)0xFFE1)->no5)
#define CSIIF01      (((volatile __near __bitf_T *)0xFFE1)->no6)
#define IICIF01      (((volatile __near __bitf_T *)0xFFE1)->no6)
#define SRIF0        (((volatile __near __bitf_T *)0xFFE1)->no6)
#define SREIF0       (((volatile __near __bitf_T *)0xFFE1)->no7)
#define TMIF01H      (((volatile __near __bitf_T *)0xFFE1)->no7)
#define IF1          (*(volatile __near unsigned short *)0xFFE2)
#define IF1L         (*(volatile __near unsigned char  *)0xFFE2)
#define IF1L_bit     (*(volatile __near __bitf_T *)0xFFE2)
#define IF1H         (*(volatile __near unsigned char  *)0xFFE3)
#define IF1H_bit     (*(volatile __near __bitf_T *)0xFFE3)
#define CSIIF10      (((volatile __near __bitf_T *)0xFFE2)->no0)
#define IICIF10      (((volatile __near __bitf_T *)0xFFE2)->no0)
#define STIF1        (((volatile __near __bitf_T *)0xFFE2)->no0)
#define CSIIF11      (((volatile __near __bitf_T *)0xFFE2)->no1)
#define IICIF11      (((volatile __near __bitf_T *)0xFFE2)->no1)
#define SRIF1        (((volatile __near __bitf_T *)0xFFE2)->no1)
#define SREIF1       (((volatile __near __bitf_T *)0xFFE2)->no2)
#define TMIF03H      (((volatile __near __bitf_T *)0xFFE2)->no2)
#define IICAIF0      (((volatile __near __bitf_T *)0xFFE2)->no3)
#define TMIF00       (((volatile __near __bitf_T *)0xFFE2)->no4)
#define TMIF01       (((volatile __near __bitf_T *)0xFFE2)->no5)
#define TMIF02       (((volatile __near __bitf_T *)0xFFE2)->no6)
#define TMIF03       (((volatile __near __bitf_T *)0xFFE2)->no7)
#define ADIF         (((volatile __near __bitf_T *)0xFFE3)->no0)
#define RTCIF        (((volatile __near __bitf_T *)0xFFE3)->no1)
#define ITIF         (((volatile __near __bitf_T *)0xFFE3)->no2)
#define KRIF         (((volatile __near __bitf_T *)0xFFE3)->no3)
#define CSIIF30      (((volatile __near __bitf_T *)0xFFE3)->no4)
#define IICIF30      (((volatile __near __bitf_T *)0xFFE3)->no4)
#define STIF3        (((volatile __near __bitf_T *)0xFFE3)->no4)
#define CSIIF31      (((volatile __near __bitf_T *)0xFFE3)->no5)
#define IICIF31      (((volatile __near __bitf_T *)0xFFE3)->no5)
#define SRIF3        (((volatile __near __bitf_T *)0xFFE3)->no5)
#define TRJIF0       (((volatile __near __bitf_T *)0xFFE3)->no6)
#define TMIF10       (((volatile __near __bitf_T *)0xFFE3)->no7)
#define MK0          (*(volatile __near unsigned short *)0xFFE4)
#define MK0L         (*(volatile __near unsigned char  *)0xFFE4)
#define MK0L_bit     (*(volatile __near __bitf_T *)0xFFE4)
#define MK0H         (*(volatile __near unsigned char  *)0xFFE5)
#define MK0H_bit     (*(volatile __near __bitf_T *)0xFFE5)
#define WDTIMK       (((volatile __near __bitf_T *)0xFFE4)->no0)
#define LVIMK        (((volatile __near __bitf_T *)0xFFE4)->no1)
#define PMK0         (((volatile __near __bitf_T *)0xFFE4)->no2)
#define PMK1         (((volatile __near __bitf_T *)0xFFE4)->no3)
#define PMK2         (((volatile __near __bitf_T *)0xFFE4)->no4)
#define PMK3         (((volatile __near __bitf_T *)0xFFE4)->no5)
#define PMK4         (((volatile __near __bitf_T *)0xFFE4)->no6)
#define PMK5         (((volatile __near __bitf_T *)0xFFE4)->no7)
#define CSIMK20      (((volatile __near __bitf_T *)0xFFE5)->no0)
#define IICMK20      (((volatile __near __bitf_T *)0xFFE5)->no0)
#define STMK2        (((volatile __near __bitf_T *)0xFFE5)->no0)
#define CSIMK21      (((volatile __near __bitf_T *)0xFFE5)->no1)
#define IICMK21      (((volatile __near __bitf_T *)0xFFE5)->no1)
#define SRMK2        (((volatile __near __bitf_T *)0xFFE5)->no1)
#define SREMK2       (((volatile __near __bitf_T *)0xFFE5)->no2)
#define TMMK11H      (((volatile __near __bitf_T *)0xFFE5)->no2)
#define CSIMK00      (((volatile __near __bitf_T *)0xFFE5)->no5)
#define IICMK00      (((volatile __near __bitf_T *)0xFFE5)->no5)
#define STMK0        (((volatile __near __bitf_T *)0xFFE5)->no5)
#define CSIMK01      (((volatile __near __bitf_T *)0xFFE5)->no6)
#define IICMK01      (((volatile __near __bitf_T *)0xFFE5)->no6)
#define SRMK0        (((volatile __near __bitf_T *)0xFFE5)->no6)
#define SREMK0       (((volatile __near __bitf_T *)0xFFE5)->no7)
#define TMMK01H      (((volatile __near __bitf_T *)0xFFE5)->no7)
#define MK1          (*(volatile __near unsigned short *)0xFFE6)
#define MK1L         (*(volatile __near unsigned char  *)0xFFE6)
#define MK1L_bit     (*(volatile __near __bitf_T *)0xFFE6)
#define MK1H         (*(volatile __near unsigned char  *)0xFFE7)
#define MK1H_bit     (*(volatile __near __bitf_T *)0xFFE7)
#define CSIMK10      (((volatile __near __bitf_T *)0xFFE6)->no0)
#define IICMK10      (((volatile __near __bitf_T *)0xFFE6)->no0)
#define STMK1        (((volatile __near __bitf_T *)0xFFE6)->no0)
#define CSIMK11      (((volatile __near __bitf_T *)0xFFE6)->no1)
#define IICMK11      (((volatile __near __bitf_T *)0xFFE6)->no1)
#define SRMK1        (((volatile __near __bitf_T *)0xFFE6)->no1)
#define SREMK1       (((volatile __near __bitf_T *)0xFFE6)->no2)
#define TMMK03H      (((volatile __near __bitf_T *)0xFFE6)->no2)
#define IICAMK0      (((volatile __near __bitf_T *)0xFFE6)->no3)
#define TMMK00       (((volatile __near __bitf_T *)0xFFE6)->no4)
#define TMMK01       (((volatile __near __bitf_T *)0xFFE6)->no5)
#define TMMK02       (((volatile __near __bitf_T *)0xFFE6)->no6)
#define TMMK03       (((volatile __near __bitf_T *)0xFFE6)->no7)
#define ADMK         (((volatile __near __bitf_T *)0xFFE7)->no0)
#define RTCMK        (((volatile __near __bitf_T *)0xFFE7)->no1)
#define ITMK         (((volatile __near __bitf_T *)0xFFE7)->no2)
#define KRMK         (((volatile __near __bitf_T *)0xFFE7)->no3)
#define CSIMK30      (((volatile __near __bitf_T *)0xFFE7)->no4)
#define IICMK30      (((volatile __near __bitf_T *)0xFFE7)->no4)
#define STMK3        (((volatile __near __bitf_T *)0xFFE7)->no4)
#define CSIMK31      (((volatile __near __bitf_T *)0xFFE7)->no5)
#define IICMK31      (((volatile __near __bitf_T *)0xFFE7)->no5)
#define SRMK3        (((volatile __near __bitf_T *)0xFFE7)->no5)
#define TRJMK0       (((volatile __near __bitf_T *)0xFFE7)->no6)
#define TMMK10       (((volatile __near __bitf_T *)0xFFE7)->no7)
#define PR00         (*(volatile __near unsigned short *)0xFFE8)
#define PR00L        (*(volatile __near unsigned char  *)0xFFE8)
#define PR00L_bit    (*(volatile __near __bitf_T *)0xFFE8)
#define PR00H        (*(volatile __near unsigned char  *)0xFFE9)
#define PR00H_bit    (*(volatile __near __bitf_T *)0xFFE9)
#define WDTIPR0      (((volatile __near __bitf_T *)0xFFE8)->no0)
#define LVIPR0       (((volatile __near __bitf_T *)0xFFE8)->no1)
#define PPR00        (((volatile __near __bitf_T *)0xFFE8)->no2)
#define PPR01        (((volatile __near __bitf_T *)0xFFE8)->no3)
#define PPR02        (((volatile __near __bitf_T *)0xFFE8)->no4)
#define PPR03        (((volatile __near __bitf_T *)0xFFE8)->no5)
#define PPR04        (((volatile __near __bitf_T *)0xFFE8)->no6)
#define PPR05        (((volatile __near __bitf_T *)0xFFE8)->no7)
#define CSIPR020     (((volatile __near __bitf_T *)0xFFE9)->no0)
#define IICPR020     (((volatile __near __bitf_T *)0xFFE9)->no0)
#define STPR02       (((volatile __near __bitf_T *)0xFFE9)->no0)
#define CSIPR021     (((volatile __near __bitf_T *)0xFFE9)->no1)
#define IICPR021     (((volatile __near __bitf_T *)0xFFE9)->no1)
#define SRPR02       (((volatile __near __bitf_T *)0xFFE9)->no1)
#define SREPR02      (((volatile __near __bitf_T *)0xFFE9)->no2)
#define TMPR011H     (((volatile __near __bitf_T *)0xFFE9)->no2)
#define CSIPR000     (((volatile __near __bitf_T *)0xFFE9)->no5)
#define IICPR000     (((volatile __near __bitf_T *)0xFFE9)->no5)
#define STPR00       (((volatile __near __bitf_T *)0xFFE9)->no5)
#define CSIPR001     (((volatile __near __bitf_T *)0xFFE9)->no6)
#define IICPR001     (((volatile __near __bitf_T *)0xFFE9)->no6)
#define SRPR00       (((volatile __near __bitf_T *)0xFFE9)->no6)
#define SREPR00      (((volatile __near __bitf_T *)0xFFE9)->no7)
#define TMPR001H     (((volatile __near __bitf_T *)0xFFE9)->no7)
#define PR01         (*(volatile __near unsigned short *)0xFFEA)
#define PR01L        (*(volatile __near unsigned char  *)0xFFEA)
#define PR01L_bit    (*(volatile __near __bitf_T *)0xFFEA)
#define PR01H        (*(volatile __near unsigned char  *)0xFFEB)
#define PR01H_bit    (*(volatile __near __bitf_T *)0xFFEB)
#define CSIPR010     (((volatile __near __bitf_T *)0xFFEA)->no0)
#define IICPR010     (((volatile __near __bitf_T *)0xFFEA)->no0)
#define STPR01       (((volatile __near __bitf_T *)0xFFEA)->no0)
#define CSIPR011     (((volatile __near __bitf_T *)0xFFEA)->no1)
#define IICPR011     (((volatile __near __bitf_T *)0xFFEA)->no1)
#define SRPR01       (((volatile __near __bitf_T *)0xFFEA)->no1)
#define SREPR01      (((volatile __near __bitf_T *)0xFFEA)->no2)
#define TMPR003H     (((volatile __near __bitf_T *)0xFFEA)->no2)
#define IICAPR00     (((volatile __near __bitf_T *)0xFFEA)->no3)
#define TMPR000      (((volatile __near __bitf_T *)0xFFEA)->no4)
#define TMPR001      (((volatile __near __bitf_T *)0xFFEA)->no5)
#define TMPR002      (((volatile __near __bitf_T *)0xFFEA)->no6)
#define TMPR003      (((volatile __near __bitf_T *)0xFFEA)->no7)
#define ADPR0        (((volatile __near __bitf_T *)0xFFEB)->no0)
#define RTCPR0       (((volatile __near __bitf_T *)0xFFEB)->no1)
#define ITPR0        (((volatile __near __bitf_T *)0xFFEB)->no2)
#define KRPR0        (((volatile __near __bitf_T *)0xFFEB)->no3)
#define CSIPR030     (((volatile __near __bitf_T *)0xFFEB)->no4)
#define IICPR030     (((volatile __near __bitf_T *)0xFFEB)->no4)
#define STPR03       (((volatile __near __bitf_T *)0xFFEB)->no4)
#define CSIPR031     (((volatile __near __bitf_T *)0xFFEB)->no5)
#define IICPR031     (((volatile __near __bitf_T *)0xFFEB)->no5)
#define SRPR03       (((volatile __near __bitf_T *)0xFFEB)->no5)
#define TRJPR00      (((volatile __near __bitf_T *)0xFFEB)->no6)
#define TMPR010      (((volatile __near __bitf_T *)0xFFEB)->no7)
#define PR10         (*(volatile __near unsigned short *)0xFFEC)
#define PR10L        (*(volatile __near unsigned char  *)0xFFEC)
#define PR10L_bit    (*(volatile __near __bitf_T *)0xFFEC)
#define PR10H        (*(volatile __near unsigned char  *)0xFFED)
#define PR10H_bit    (*(volatile __near __bitf_T *)0xFFED)
#define WDTIPR1      (((volatile __near __bitf_T *)0xFFEC)->no0)
#define LVIPR1       (((volatile __near __bitf_T *)0xFFEC)->no1)
#define PPR10        (((volatile __near __bitf_T *)0xFFEC)->no2)
#define PPR11        (((volatile __near __bitf_T *)0xFFEC)->no3)
#define PPR12        (((volatile __near __bitf_T *)0xFFEC)->no4)
#define PPR13        (((volatile __near __bitf_T *)0xFFEC)->no5)
#define PPR14        (((volatile __near __bitf_T *)0xFFEC)->no6)
#define PPR15        (((volatile __near __bitf_T *)0xFFEC)->no7)
#define CSIPR120     (((volatile __near __bitf_T *)0xFFED)->no0)
#define IICPR120     (((volatile __near __bitf_T *)0xFFED)->no0)
#define STPR12       (((volatile __near __bitf_T *)0xFFED)->no0)
#define CSIPR121     (((volatile __near __bitf_T *)0xFFED)->no1)
#define IICPR121     (((volatile __near __bitf_T *)0xFFED)->no1)
#define SRPR12       (((volatile __near __bitf_T *)0xFFED)->no1)
#define SREPR12      (((volatile __near __bitf_T *)0xFFED)->no2)
#define TMPR111H     (((volatile __near __bitf_T *)0xFFED)->no2)
#define CSIPR100     (((volatile __near __bitf_T *)0xFFED)->no5)
#define IICPR100     (((volatile __near __bitf_T *)0xFFED)->no5)
#define STPR10       (((volatile __near __bitf_T *)0xFFED)->no5)
#define CSIPR101     (((volatile __near __bitf_T *)0xFFED)->no6)
#define IICPR101     (((volatile __near __bitf_T *)0xFFED)->no6)
#define SRPR10       (((volatile __near __bitf_T *)0xFFED)->no6)
#define SREPR10      (((volatile __near __bitf_T *)0xFFED)->no7)
#define TMPR101H     (((volatile __near __bitf_T *)0xFFED)->no7)
#define PR11         (*(volatile __near unsigned short *)0xFFEE)
#define PR11L        (*(volatile __near unsigned char  *)0xFFEE)
#define PR11L_bit    (*(volatile __near __bitf_T *)0xFFEE)
#define PR11H        (*(volatile __near unsigned char  *)0xFFEF)
#define PR11H_bit    (*(volatile __near __bitf_T *)0xFFEF)
#define CSIPR110     (((volatile __near __bitf_T *)0xFFEE)->no0)
#define IICPR110     (((volatile __near __bitf_T *)0xFFEE)->no0)
#define STPR11       (((volatile __near __bitf_T *)0xFFEE)->no0)
#define CSIPR111     (((volatile __near __bitf_T *)0xFFEE)->no1)
#define IICPR111     (((volatile __near __bitf_T *)0xFFEE)->no1)
#define SRPR11       (((volatile __near __bitf_T *)0xFFEE)->no1)
#define SREPR11      (((volatile __near __bitf_T *)0xFFEE)->no2)
#define TMPR103H     (((volatile __near __bitf_T *)0xFFEE)->no2)
#define IICAPR10     (((volatile __near __bitf_T *)0xFFEE)->no3)
#define TMPR100      (((volatile __near __bitf_T *)0xFFEE)->no4)
#define TMPR101      (((volatile __near __bitf_T *)0xFFEE)->no5)
#define TMPR102      (((volatile __near __bitf_T *)0xFFEE)->no6)
#define TMPR103      (((volatile __near __bitf_T *)0xFFEE)->no7)
#define ADPR1        (((volatile __near __bitf_T *)0xFFEF)->no0)
#define RTCPR1       (((volatile __near __bitf_T *)0xFFEF)->no1)
#define ITPR1        (((volatile __near __bitf_T *)0xFFEF)->no2)
#define KRPR1        (((volatile __near __bitf_T *)0xFFEF)->no3)
#define CSIPR130     (((volatile __near __bitf_T *)0xFFEF)->no4)
#define IICPR130     (((volatile __near __bitf_T *)0xFFEF)->no4)
#define STPR13       (((volatile __near __bitf_T *)0xFFEF)->no4)
#define CSIPR131     (((volatile __near __bitf_T *)0xFFEF)->no5)
#define IICPR131     (((volatile __near __bitf_T *)0xFFEF)->no5)
#define SRPR13       (((volatile __near __bitf_T *)0xFFEF)->no5)
#define TRJPR10      (((volatile __near __bitf_T *)0xFFEF)->no6)
#define TMPR110      (((volatile __near __bitf_T *)0xFFEF)->no7)
#define MACRL        (*(volatile __near unsigned short *)0xFFF0)
#define MACRH        (*(volatile __near unsigned short *)0xFFF2)
#define PMC          (*(volatile __near unsigned char  *)0xFFFE)
#define PMC_bit      (*(volatile __near __bitf_T *)0xFFFE)
#define MAA          (((volatile __near __bitf_T *)0xFFFE)->no0)


#define INTWDTI                         0x0004
#define INTLVI                          0x0006
#define INTP0                           0x0008
#define INTP1                           0x000A
#define INTP2                           0x000C
#define INTP3                           0x000E
#define INTP4                           0x0010
#define INTP5                           0x0012
#define INTCSI20                        0x0014
#define INTIIC20                        0x0014
#define INTST2                          0x0014
#define INTCSI21                        0x0016
#define INTIIC21                        0x0016
#define INTSR2                          0x0016
#define INTSRE2                         0x0018
#define INTTM11H                        0x0018
#define INTCSI00                        0x001E
#define INTIIC00                        0x001E
#define INTST0                          0x001E
#define INTCSI01                        0x0020
#define INTIIC01                        0x0020
#define INTSR0                          0x0020
#define INTSRE0                         0x0022
#define INTTM01H                        0x0022
#define INTCSI10                        0x0024
#define INTIIC10                        0x0024
#define INTST1                          0x0024
#define INTCSI11                        0x0026
#define INTIIC11                        0x0026
#define INTSR1                          0x0026
#define INTSRE1                         0x0028
#define INTTM03H                        0x0028
#define INTIICA0                        0x002A
#define INTTM00                         0x002C
#define INTTM01                         0x002E
#define INTTM02                         0x0030
#define INTTM03                         0x0032
#define INTAD                           0x0034
#define INTRTC                          0x0036
#define INTIT                           0x0038
#define INTKR                           0x003A
#define INTCSI30                        0x003C
#define INTIIC30                        0x003C
#define INTST3                          0x003C
#define INTCSI31                        0x003E
#define INTIIC31                        0x003E
#define INTSR3                          0x003E
#define INTTRJ0                         0x0040
#define INTTM10                         0x0042
#define INTTM11                         0x0044
#define INTTM12                         0x0046
#define INTTM13                         0x0048
#define INTP6                           0x004A
#define INTP7                           0x004C
#define INTP8                           0x004E
#define INTP9                           0x0050
#define INTCMP0                         0x0052
#define INTP10                          0x0052
#define INTCMP1                         0x0054
#define INTP11                          0x0054
#define INTTRD0                         0x0056
#define INTTRD1                         0x0058
#define INTTRG                          0x005A
#define INTSRE3                         0x005C
#define INTTM13H                        0x005C
#define INTIICA1                        0x0060
#define INTFL                           0x0062

#endif
