/*
 * mcu_tim.h
 *
 *  Created on: 25 ���. 2018 �.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 *      this is for STM SPL compatibily wrapers
 */

#ifndef HAL_MDR32F9QX_MCU_TIM_H_
#define HAL_MDR32F9QX_MCU_TIM_H_

#include <stdint.h>
#include <mcu-chip.h>

// #if defined(__CM4_REV) || (__CORTEX_M == 4)
#if defined(STM32F4)   //__STM32F4xx_HAL_CONF_H
#include <stm32f4xx_ll_tim.h>
#elif defined(STM32L1)
#include <stm32l1xx_ll_tim.h>
#else
#warning "uncknown STM32 HAL"
#endif

#include <c_compat.h>

#ifdef STM32F446xx

// slave mode time sources
#define TIM3_TS_TIM1   LL_TIM_TS_ITR0
#define TIM3_TS_TIM2   LL_TIM_TS_ITR1
#define TIM3_TS_TIM4   LL_TIM_TS_ITR3
#define TIM3_TS_TIM5   LL_TIM_TS_ITR2

#define TIM4_TS_TIM1   LL_TIM_TS_ITR0
#define TIM4_TS_TIM2   LL_TIM_TS_ITR1
#define TIM4_TS_TIM3   LL_TIM_TS_ITR2
#define TIM4_TS_TIM8   LL_TIM_TS_ITR3

#define TIM5_TS_TIM2   LL_TIM_TS_ITR0
#define TIM5_TS_TIM3   LL_TIM_TS_ITR1
#define TIM5_TS_TIM4   LL_TIM_TS_ITR2
#define TIM5_TS_TIM8   LL_TIM_TS_ITR3

#define TIM8_TS_TIM1   LL_TIM_TS_ITR0
#define TIM8_TS_TIM2   LL_TIM_TS_ITR1
#define TIM8_TS_TIM4   LL_TIM_TS_ITR2
#define TIM8_TS_TIM5   LL_TIM_TS_ITR3

#endif

#define SysTick_MAX         (SysTick_LOAD_RELOAD_Msk)

INLINE
void TIM_Cmd(TIM_TypeDef* TIMx, int onoff) {
    if ( (onoff) == ENABLE)
        LL_TIM_EnableCounter(TIMx);
    else
        LL_TIM_DisableCounter(TIMx);
}

INLINE
void TIM_SetCHCompare(TIM_TypeDef* TIMx, int ch, unsigned x){
    *(&(TIMx->CCR1) + ch) = x;
}

//-----------------------------------------------------------------
// this is port of through all HALs
#define TIM_enable(TIMx)   LL_TIM_EnableCounter(TIMx)
#define TIM_disable(TIMx)  LL_TIM_DisableCounter(TIMx)
#define TIM_is_enabled(TIMx) LL_TIM_IsEnabledCounter(TIMx)

#define TIM_STATUS(TIMx)  (TIMx)->SR

#define TIM_IE(TIMx)  (TIMx)->DIER
#define TIM_IE_enable(TIMx, mask)   SET_BIT(TIMx->DIER, (mask) )
#define TIM_IE_disable(TIMx, mask)  CLEAR_BIT(TIMx->DIER, (mask) )

#define TIM_IE_ZERO         TIM_DIER_UIE
#define TIM_IE_RELOAD       TIM_DIER_UIE
#define TIM_IE_TRIG         TIM_DIER_TIE
#define TIM_IE_OC1          TIM_DIER_CC1IE
#define TIM_IE_OC2          TIM_DIER_CC2IE
#define TIM_IE_OC3          TIM_DIER_CC3IE
#define TIM_IE_OC4          TIM_DIER_CC4IE
#define TIM_IE_OCx          (TIM_DIER_CC1IE | TIM_DIER_CC2IE | TIM_DIER_CC3IE | TIM_DIER_CC4IE)
#define TIM_IE_OCx_Pos      TIM_DIER_CC1IE_Pos

#define TIM_SetAutoReload(io, x)    LL_TIM_SetAutoReload(io, x)


#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
}
#endif

#endif /* HAL_MDR32F9QX_MCU_USART_H_ */
