#ifndef TESTSHELL_H
#define TESTSHELL_H

#include <QDialog>
#include <lib/cli/console_ui.h>
#include <lib/cli/qshell.hpp>
#include <qio_devices.hpp>



namespace Ui {
class TestShell;
}

class TestShell : public QDialog
{
    Q_OBJECT

public:
    explicit TestShell(QWidget *parent = nullptr);
    ~TestShell();

    QShell& shell() {return *_shell;}

private slots:

    void on_buttonBox_accepted();
    
    void on_buttonBox_rejected();

    void on_input(const QByteArray data);
    
protected:
    Console         ui_console;
    QConsoleIODevice*   io_console; //QShell::io_t
    QShell*         _shell;

private:
    Ui::TestShell *ui;
};

#endif // TESTSHELL_H
