#ifndef TELNETD_HPP
#define TELNETD_HPP

#include <lib/cli/qshell_telnet.hpp>
#include <logger.h>
#include <core.h>
#include <lib/cli/qcli.hpp>

class TelnetDaemon : public QTelnetTCPServer
{
    Q_OBJECT
public:
    typedef QTelnetTCPServer inherited;
    TelnetDaemon(TCore* acore,  QObject *parent = nullptr);
    ~TelnetDaemon() override;

    bool listen(const QHostAddress &address = QHostAddress::Any, quint16 port = 0);
    bool listen(quint16 port){  return listen(QHostAddress::Any, port);  }
    bool listen_local(quint16 port){  return listen(QHostAddress::LocalHost, port);  }

    void close();

public slots:
    void destroy();
    void shutdown();

protected:
    service_t* new_service( unsigned id, qintptr handle) override;

protected:
    TCore*  core;
    std::string _name;
    const char* name();

protected:
    void cli_init();
	std::unique_ptr<QCLIDeviceCommands> cli_api;

public:
	bool event(::QEvent *ev) override;

	typedef cli::QEvent QEvent;
	static QEvent	evDestroy;
	static QEvent	evShutdown;
};



class TelnetShell : public TelnetQShell
{
	Q_OBJECT
public:
	typedef TelnetQShell inherited;
	TelnetShell(portid port
	            , const std::string& shell_name
	            , TCore* acore);
	~TelnetShell() override;
	
protected:
	TCore*  core;

protected:
	CLICommandInvoke	info_cli;

	int cli_info(CLI_shell* shell, cli::const_line line);
};



#endif // TELNETD_HPP
