/*
 * bits_util.hpp
 *
 *  Created on: 18 . 2017 .
 *      Author: alexrayne
 */

#ifndef APP_BITS_UTIL_HPP_
#define APP_BITS_UTIL_HPP_

#include <stdint.h>

uint8_t  bits_reverse(uint8_t x);
uint16_t bits_reversew(uint16_t x);
//* swap bit pairs in byte
uint8_t bits2_reverse(uint8_t x);
uint16_t bits2byte_reversew(uint16_t x);

//* \return - expands bits of x to 2bits groups
uint16_t bits2byte_expand(uint8_t x);

template <typename T>
inline T bits_mask(unsigned m, unsigned L){
    const unsigned w = m-L+1;
    return ((1u<<w) -1) << L ;
}

template <typename T>
inline
T bits_extract(T data, unsigned m, unsigned l){
    return data & bits_mask<T>(m,l);
}

#if __GNUC__
#define swap16(x) __builtin_bswap16(x)
#define swap32(x) __builtin_bswap32(x)
#else
uint16_t swap16(uint16_t x);
uint16_t swap32(uint16_t x);
#endif

// \arg shift < 8
void str_rshift(void* dst, const void* src, unsigned size, unsigned shift);
void str_scale_bits(void* dst, unsigned shiftd
                             , const void* src, unsigned shifts, unsigned bits
                             , unsigned scale);

#endif /* APP_BITS_UTIL_HPP_ */
