/*
 * Copyright (c) 2005, Swedish Institute of Computer Science
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is part of the Contiki operating system.
 *
 */
#ifndef WATCHDOG_H_
#define WATCHDOG_H_

#include <contiki-conf.h>


/*---------------------------------------------------------------------------*/
//< Watchdog stall when debugger stop cpu
#define CONTIKI_WATCHDOG_STALL      2
//< Watchdog not initate in contiki-main
#define CONTIKI_WATCHDOG_OFF        0
//< System without watchdog
#define CONTIKI_WATCHDOG_NONE       -1

#ifndef CONTIKI_WATCHDOG_CONF
#define CONTIKI_WATCHDOG_CONF       1
#endif

/*---------------------------------------------------------------------------*/
#if (CONTIKI_WATCHDOG_CONF >= 0)

void watchdog_init(void);
void watchdog_start(void);

/* Do not use this function from within an interrupt context */
void watchdog_periodic(void);
void watchdog_stop(void);

void watchdog_reboot(void);

#else

#define watchdog_init()
#define watchdog_start()
#define watchdog_periodic()
#define watchdog_stop()
#define watchdog_reboot()

#endif

#endif /* WATCHDOG_H_ */
