package org.jent.checksmtp;

import java.util.ArrayList;

import javax.swing.JDialog;

import junit.framework.TestCase;

import junit.swingui.TestRunner;

import org.jent.checksmtp.ResultNotify;
import org.jent.checksmtp.ToListDialog;

public class ToListDialogTest extends TestCase implements ResultNotify {

  private final ArrayList arrayList = new ArrayList();
  private JDialog toListDialog = null;
  private boolean result = false;

  public ToListDialogTest(String sTestName) {
    super(sTestName);
  }

  public static void main(String args[]) {
    String args2[] = {"-noloading", "test.org.jent.checksmtp.ToListDialogTest"};
    TestRunner.main(args2);
  }

  protected void setUp() throws Exception {
    super.setUp();

  }

  protected void tearDown() throws Exception {
    super.tearDown();
    toListDialog.dispose();
  }
  
  private synchronized void notifyResult() {
    notify();
  }
  public void sayOK() {
    result = true;
    notifyResult();
  }
  public void sayNG() {
    result = false;
    notifyResult();
  }

  private void pushTestSetup(String msg) {
    arrayList.add(msg);
    for (int i = 0; i < 100; i++) {
      arrayList.add("NO" + i);
    }
    toListDialog = new ToListDialog(this, arrayList);
    arrayList.clear();

    try {
      synchronized (this) {
        wait(30 * 1000);
        //Wait 30sec
      }
    } catch (InterruptedException e) {
      fail("Dialg wait interrupted");
    }
  }

  public void testPushOK() {
    pushTestSetup("Please push OK button.");
    assertTrue("Time out or push CANCEL", result);
  }
  
  public void testPushCANCEL() {
    pushTestSetup("Please push CANCEL button.");
    assertTrue("Time out or push OK", !result);
  }

  public void testPushClose() {
    pushTestSetup("Please close Window.");
    assertTrue("Time out or push OK", !result);
  }
  
}
