package org.jent.checksmtp;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;


public class ToListDialog extends JDialog {
  private JButton jButtonOK = new JButton();
  private JButton jButtonCANCEL = new JButton();
  private JList jList1 = new JList();
  private JScrollPane scrollPane = new JScrollPane(); //add
  private List toList = null;
  private ResultNotify resultNotify = null;

  private JPanel bottonPanel = new JPanel();


  private BorderLayout borderLayout1 = new BorderLayout();

  public ToListDialog() {
      this(null, "", false);
  }

  public ToListDialog(Frame parent, String title, boolean modal) {
      super(parent, title, modal);

      try {
          jbInit();
      } catch (Exception e) {
          e.printStackTrace();
      }
  }

  public ToListDialog(ResultNotify processer, List toList) {
      this(null, "TO Check", false);
      this.toList = toList;
      this.resultNotify = processer;

      if (toList != null) {
          jList1.setListData(toList.toArray());

          //jList1.update();
          jList1.setVisible(true);
      }

      this.setVisible(true);
  }

  private void jbInit() throws Exception {
    this.setLookAndFeelSuitable();
    this.setSize(new Dimension(584, 300));
    this.getContentPane().setLayout(borderLayout1);
    this.setTitle("Conform Mail Destination");
    this.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        this_windowClosing(e);
      }
    });

    jList1.setBounds(new Rectangle(25, 25, 455, 200));
    jList1.setSize(new Dimension(500, 200));
    jList1.setToolTipText("null");
    jList1.setValueIsAdjusting(true);
    scrollPane.setAutoscrolls(true);
    scrollPane.getViewport().setView(jList1); //add
    
    jButtonOK.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonOK_actionPerformed(e);
      }
    });
    jButtonCANCEL.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonCANCEL_actionPerformed(e);
      }
    });
    jButtonOK.setText("OK");
    jButtonCANCEL.setText("CANCEL");
   
    bottonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    bottonPanel.add(jButtonCANCEL, null);
    bottonPanel.add(jButtonOK, null);

    this.getContentPane().add(bottonPanel, BorderLayout.SOUTH);
    this.getContentPane().add(scrollPane, BorderLayout.CENTER);
    
    //Display Center  setLocationRelativeTo(null);
    //setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE); //Default
  }

  /*
   *  set OS default look&feel
   */
  private void setLookAndFeelSuitable() {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void jButtonOK_actionPerformed(ActionEvent e) {
    //push OK
    resultNotify.sayOK();
    this.dispose();
  }

  private void jButtonCANCEL_actionPerformed(ActionEvent e) {
    resultNotify.sayNG();
    this.dispose();
  }

  private void this_windowClosing(WindowEvent e) {
    resultNotify.sayNG();
  }
}
