using System;
using System.Diagnostics;
using System.Collections.Generic;
namespace mdc5linker{
	class ToMain{
#if DEBUG
		static readonly string PATH = @"D:/work/mdc5/linker/";
#else
		static readonly string PATH = System.Windows.Forms.Application.StartupPath + @"\";
#endif
		public const string VERSION = "mdc5 linker version 0.1.0\n";
		static void Main(string[] argv)
		{
			Interface.Konfig config = new Interface.Konfig(PATH);
			config.FileLoad(PATH);
			if(argv.Length == 0){
				mdc5linker.imageselecter t = new mdc5linker.imageselecter(config);
				System.Windows.Forms.Application.EnableVisualStyles();
				//System.Windows.Forms.Application.SetCompatibleTextRenderingDefault(false);
				System.Windows.Forms.Application.Run(t);
				return;
			}

			Console.Write(VERSION);
			if(argv[0] == "-l"){
				CuiLogger log = new CuiLogger();
				Interface.Scanner s = new Interface.Scanner();
				log.Subscribe(s);
				s.HashlistScreenOut(config.PathGet("diskimage.in"));
			}else{
				ConsoleLinker linker = new ConsoleLinker();
				if(linker.LoadArgument(argv) != false){
					linker.Link(config);
				}
			}
		}
	}
	class ConsoleLinker{
		bool m_output_nes = false, m_output_bin = false;
		bool m_do_patch = true;
		string m_output_prefix = "";
		string [] m_input_fds;
		int m_romsize = mdc5.Manage.CAPACITY_AUTO;
		
		bool capacity_get(string str, ref int capacity)
		{
			int M = 0x20000;
			switch(str){
			case "Auto":
				m_romsize = mdc5.Manage.CAPACITY_AUTO;
				break;
			case "512K":
				capacity = M / 2;
				break;
			case "1M":
				capacity = 1 * M;
				break;
			case "2M":
				capacity = 2 * M;
				break;
			case "4M":
				capacity = 4 * M;
				break;
			case "8M":
				capacity = 8 * M;
				break;
			}
			return true;
		}
		public bool LoadArgument(string[] argv)
		{
			Queue<string> t = new Queue<string>(argv);
			List<string> fdslist = new List<string>();
			while(t.Count != 0){
				string argv0 = t.Dequeue();
				switch(argv0){
				case "-o":
					if(t.Count == 0){
						Console.Write("argument Error {0}", argv0);
						return false;
					}
					m_output_prefix = t.Dequeue();
					break;
				case "-n":
					m_output_nes = true;
					break;
				case "-b":
					m_output_bin = true;
					break;
				case "-c":
					if(t.Count == 0){
						Console.Write("argument Error {0}", argv0);
						return false;
					}
					string cap = t.Dequeue();
					if(capacity_get(cap, ref m_romsize) == false){
						Console.Write("unknown capacity {0}", cap);
						return false;
					}
					break;
				case "-l":
					Console.Write("argument Error {0}", argv0);
					return false;
				case "-q":
					m_do_patch = false;
					break;
				default:
					fdslist.Add(argv0);
					break;
				}
			}
			m_input_fds = fdslist.ToArray();
			return true;
		}
		public void Link(Interface.Konfig config)
		{
			CuiLogger log = new CuiLogger();
			Interface.Scanner s = new Interface.Scanner();
			log.Subscribe(s);

			mdc5.Script [] script_list;
			if(s.FilenameToScript(m_input_fds, config.PathGet("diskscript.in"), out script_list) == false){
				Console.Write("script not found");
				return;
			}
			if(m_output_prefix == ""){
				m_output_prefix = AutoFilenameGet(script_list);
			}
			config.RomCapacity = m_romsize;
			mdc5.GameImage m = new mdc5.GameImage();
			log.Subscribe(m);
			m.BatchLink(
				config, script_list, m_output_prefix,
				m_output_bin, m_output_nes, m_do_patch
			);
			config.OutputBin = m_output_bin;
			config.OutputNes = m_output_nes;
			config.FileSave();
		}
		static public string AutoFilenameGet(mdc5.Script [] list)
		{
			string ret = "";
			foreach(mdc5.Script s in list){
				System.Text.RegularExpressions.GroupCollection g;
				string pattern = @"^([0-9A-Z]{3})\-([0-9A-Z]{3,4})";
				pattern += @"(,([0-9A-Z]{3})\-([0-9A-Z]{3,4}))?$"; //2毎目の型番はなくてもよい
				if(Static.Utility.matching(s.GameCode, pattern, out g) == true){
					ret += g[2].Value.ToLower() + "_";
					if(g[5].Value != ""){
						ret += g[5].Value.ToLower() + "_";
					}
				}
			}
			return ret.Substring(0, ret.Length - 1);
		}
	}
}
