TARGET = \
	ann_nsm.mdc btc_rlc.mdc \
	dfc_juk.mdc dfc_kf12.mdc dfc_j4.mdc \
	fmc_tc12.mdc fmc_tc34.mdc fmc_ppn.mdc fmc_thse.mdc fmc_smb.mdc \
	ifd_sl2.mdc ima_gin.mdc jfd_dfs.mdc jfd_ggb.mdc \
	kds_esp.mdc kds_aka.mdc kds_you.mdc kds_nzn.mdc kds_twn.mdc \
	kds_akm_v0.mdc kds_akm_v1.mdc \
	ksc_elc.mdc pnf_dan.mdc pnf_win.mdc \
	sfc_fyt.mdc sfc_neu.mdc sfc_psr.mdc ssd_dzn.mdc \
	sqf_krn.mdc sqf_rjn.mdc 
#	ifd_slr.mdc ban_sg1.mdc \
#	sfc_fyt.mdc 
ADDRESS_RANGE = \$$6000-\$$dfff
TYPE = disk

include mdc.mk

#multi version specify for KDS-AKM
kds_akm_v0.o: kds_akm.s
	$(AS) -D version=0 -l -o $@ $< > $(subst .o,.lst,$@)
kds_akm_v1.o: kds_akm.s
	$(AS) -D version=1 -l -o $@ $< > $(subst .o,.lst,$@)
#filename specify for ANN-NSM
ann_nsm.o: ann_nsm.s
	$(AS) -D version=0 -L -o $@ $<
ann_nsm_main.mot: ann_nsm.o
	$(P2HEX) $< $@ -r \$$6000-\$$c5cf -F moto
ann_nsm_data.mot: ann_nsm.o
	$(P2HEX) $< $@ -r \$$c5d0-\$$dfff -F moto
ann_nsm.mdc: ../mdc/ann_nsm.mdt ann_nsm_main.mot ann_nsm_data.mot
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	#
	printf "$(PATCH_PREFIX)file = NSMMAIN\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ann_nsm_main.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	printf "$(PATCH_PREFIX)file = NSMDATA3\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ann_nsm_data.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	cp $@ $(MDCDIR)

#for FMC-SMB
fmc_smb.o: ann_nsm.s
	$(AS) -D version=1 -l -o $@ $< > fmc_smb.lst
fmc_smb_main.mot: fmc_smb.o
	$(P2HEX) $< $@ -r \$$6000-\$$c5cf -F moto
fmc_smb_data.mot: fmc_smb.o
	$(P2HEX) $< $@ -r \$$c5d0-\$$dfff -F moto
fmc_smb.mdc: ../mdc/fmc_smb.mdt fmc_smb_main.mot fmc_smb_data.mot
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	#
	printf "$(PATCH_PREFIX)file = SM2MAIN\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat fmc_smb_main.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	printf "$(PATCH_PREFIX)file = SM2DATA3\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat fmc_smb_data.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	cp $@ $(MDCDIR)

#address filter for SSD-DZN. range for disk1.sideA.DOS
ssd_dzn.mot: ssd_dzn.o
	$(P2HEX) $< $@ -r \$$0450-\$$067d -F moto

#J[̌:SQF-KRN
sqf_krn_start.mot: sqf_krn.o
	$(P2HEX) $< $@ -r \$$6000-\$$acef -F moto
sqf_krn_open.mot: sqf_krn.o
	$(P2HEX) $< $@ -r \$$b100-\$$dcef -F moto
sqf_krn.mdc: ../mdc/sqf_krn.mdt sqf_krn_start.mot sqf_krn_open.mot
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	#
	printf "$(PATCH_PREFIX)file = START UP\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat sqf_krn_start.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	printf "$(PATCH_PREFIX)file = OPENING\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat sqf_krn_open.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	cp $@ $(MDCDIR)

ifd_sl2_auto.mot: ifd_sl2.o
	$(P2HEX) $< $@ -r \$$6000-\$$d9ae -F moto
ifd_sl2_protect.mot: ifd_sl2.o
	$(P2HEX) $< $@ -r \$$d9af-\$$dfff -F moto
ifd_sl2.mdc: ifd_sl2_auto.mot ifd_sl2_protect.mot ../mdc/ifd_sl2.mdt
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	#
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ifd_sl2_auto.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	printf "$(PATCH_PREFIX)file = PROTECT\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ifd_sl2_protect.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	#
	cp $@ $(MDCDIR)

ifd_slr.mdc: ifd_slr.mot ../mdc/ifd_sl2.mdt
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	printf "$(PATCH_PREFIX)file = PROTECT\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat ifd_slr.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	cp $@ $(MDCDIR)
