TARGET = \
	cap_rx.mdc cap_xr.mdc \
	dfc_yk.mdc hfc_so.mdc \
	nes_jk_usa.mdc nes_cv_usa.mdc \
	rc809.mdc rc810.mdc rc818.mdc rc821_pub.mdc \
	tcf_ah.mdc tcf_sk.mdc tcf_st.mdc tcf_tm.mdc \
	dfc_he.mdc hfc_km.mdc hfc_mi.mdc hfc_tb.mdc \
	tdf_hk.mdc tdf_ho.mdc tjc_kn.mdc 
ADDRESS_RANGE = \$$8000-\$$ffff
TYPE = rom

include mdc.mk

rc821_pub.o: rc821.s
	$(AS) -D version=0 -l -o $@ $< > $(subst .o,.lst,$@)

#for CAP-XR.. Rockman2 ʤƤ⤤Ƥɰ
cap_xr_page0e.mot: cap_xr.o
	$(P2HEX) $< $@ -r \$$8000-\$$bfff -F moto
cap_xr_page0f.mot: cap_xr.o
	$(P2HEX) $< $@ -r \$$c000-\$$ffff -F moto
cap_xr.mdc: ../mdc/cap_xr.mdt cap_xr_page0e.mot cap_xr_page0f.mot
	cat $(MDCDIR)/$(subst .mdc,.mdt,$@) > $@
	printf "$(PATCH_PREFIX)rom.offset = 0x38000\r\n" >> $@
	printf "$(PATCH_PREFIX)cpu.address = 0x8000\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat cap_xr_page0e.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	printf "$(PATCH_PREFIX)rom.offset = 0x3c000\r\n" >> $@
	printf "$(PATCH_PREFIX)cpu.address = 0xc000\r\n" >> $@
	printf "$(PATCH_PREFIX)start\r\n" >> $@
	cat cap_xr_page0f.mot >> $@
	printf "$(PATCH_PREFIX)end\r\n" >> $@
	cp $@ $(MDCDIR)
