//---------------------------------------------------------------------------
// HNX
// $Id: KMaze.h 351 2006-08-12 16:15:31Z kaityo $
//---------------------------------------------------------------------------

#ifndef KMazeH
#define KMazeH
//---------------------------------------------------------------------------
class KMaze {
private:
  int LX,LY;
  bool *bond_h;
  bool *bond_v;
  int *Point;
  bool *bOccupiedGrid;

  TColor StartPointColor;
  TColor EndPointColor;

  bool *ansbond_h;
  bool *ansbond_v;

  int readCellValue(int x, int y) {
    return x+y;
  };
  void writeCellValue(int x, int y, int value) {
    ShowMessage(IntToStr(value));
  };
  int SizeofGrid;
  int readGridSize(void) {
    return SizeofGrid;
  };
  void writeGridSize(int gs) {
    if(gs < GridSizeMin)
      gs = GridSizeMin;
    if(gs > GridSizeMax)
      gs = GridSizeMax;
    SizeofGrid = gs;
    LeftMargin = gs;
    TopMargin = gs;
  };

  bool readBondHorizontal(int x, int y) {
    return bond_h[(LX+1)*y+x];
  };
  void writeBondHorizontal(int x, int y, bool b) {
    bond_h[(LX+1)*y+x] = b;
  };

  bool readBondVertical(int x, int y) {
    return bond_v[LX*y+x];
  };
  void writeBondVertical(int x, int y, bool b) {
    bond_v[LX*y+x] = b;
  };

  bool readAnswerBondHorizontal(int x, int y) {
    return ansbond_h[(LX+1)*y+x];
  };
  void writeAnswerBondHorizontal(int x, int y, bool b) {
    ansbond_h[(LX+1)*y+x] = b;
  };

  bool readAnswerBondVertical(int x, int y) {
    return ansbond_v[LX*y+x];
  };

  void writeAnswerBondVertical(int x, int y, bool b) {
    ansbond_v[LX*y+x] = b;
  };

  bool readOccupiedGrid(int x, int y){
    if(x < 0) return false;
    if(y < 0) return false;
    if(x >= LX) return false;
    if(y >= LY) return false;
    return bOccupiedGrid[y*LX+x];
  };

  void writeOccupiedGrid(int x, int y, bool b){
    if(x < 0) return;
    if(y < 0) return;
    if(x >= LX) return;
    if(y >= LY) return;
    bOccupiedGrid[y*LX+x] = b;
  };

  //H쐬
  void MakeMazeSub(void);
  void MakeMazeFinal(void);
  //NX^O
  int GetClasterIndex(int x, int y);
  void Clastering(void);
  void Connect(int ix1, int iy1, int ix2, int iy2);
  void DrawPoint(TCanvas *Canvas);

  static const int GridSizeMin;
  static const int GridSizeMax;

public:
  KMaze(void);
  ~KMaze(void);

  static TColor BGColor,LineColor, FGColor, GridColor, TransparentColor;
  bool bDrawAnswer;
  bool TransparentMode;

  void Init(void);
  void InitAnswer(void);
  void MakeMaze(void);
  void SetSize(int _LX, int _LY);
  void GetDrawSize(int &Width, int &Height);

  int SX,SY,EX,EY;

  int GetLX(void) {
    return LX;
  };
  int GetLY(void) {
    return LY;
  };

  int TopMargin, LeftMargin;
  int __property GridSize = {read=readGridSize, write = writeGridSize};
  bool __property Bond_h[int x][int y] = {read=readBondHorizontal, write=writeBondHorizontal};
  bool __property Bond_v[int x][int y] = {read=readBondVertical, write=writeBondVertical};

  bool __property AnswerBond_h[int x][int y] = {read=readAnswerBondHorizontal, write=writeAnswerBondHorizontal};
  bool __property AnswerBond_v[int x][int y] = {read=readAnswerBondVertical, write=writeAnswerBondVertical};

  bool __property OccupiedGrid[int x][int y]  = {read=readOccupiedGrid, write=writeOccupiedGrid};

  void Draw(TCanvas *Canvas);
  void DrawAnswer(TCanvas *Canvas);
  void DrawAnswerBold(TCanvas *Canvas);
  void DrawGrid(TCanvas *Canvas);
  void DrawOccupiedGrid(TCanvas *Canvas);

  void SaveToFile(char *filename);
  bool LoadFromFile(char *filename);


};
//---------------------------------------------------------------------------
#endif
