//---------------------------------------------------------------------------
// Y CtH[
// $Id: main.cpp 367 2006-08-15 15:52:56Z kaityo $
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "main.h"
#include "SetSize.h"
#include "Version.h"
#include "HHelp.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFMain *FMain;

enum MODE{MODE_EDIT, MODE_ANSWER};
enum {D_DOWN,D_UP,D_LEFT,D_RIGHT} DIR;

int dx[4],dy[4];

const char *Version = "Y - Ver 1.03";
const char *helpfilename = "meijiro.chm";

//---------------------------------------------------------------------------
/**
 * RXgN^
 */
__fastcall
TFMain::TFMain(TComponent* Owner)
    : TForm(Owner) {
  Maze = new KMaze;

  DefaultPath = ExtractFilePath(Application->ExeName);
  HelpFile = DefaultPath + helpfilename;
  Mode = MODE_EDIT;
  FileName = "";
  Image->Canvas->Brush->Color = clWhite;
  Image->Canvas->FillRect(Rect(0,0,Image->Width,Image->Height));
  dx[D_UP] = 0; dy[D_UP] = -1;
  dx[D_DOWN] = 0; dy[D_DOWN] = 1;
  dx[D_LEFT] = -1; dy[D_LEFT] = 0;
  dx[D_RIGHT] = 1; dy[D_RIGHT] = 0;
  htmlhelp = Htmlhelp::GetInstance();

}
//---------------------------------------------------------------------------
/**
 * Еt
 */
void __fastcall
TFMain::FormClose(TObject *Sender, TCloseAction &Action) {
  delete Maze;
}
//---------------------------------------------------------------------------
void
TFMain::Init(void) {
  Mode = MODE_EDIT;
  MazeMade = false;
  Maze->InitAnswer();
  MazeAvailable = false;
  Modified = false;
  ChangeSize();
  ShowStatus("n_߂Ă(DF̕)");
  UpdateCaption();
}
//---------------------------------------------------------------------------
/**
 * LvVAc[o[ȂǂǗB
 */
void
TFMain::UpdateCaption(void) {
  if(FileName == "") {
    if(Modified){
      Caption = "Y * VKt@C" + FileName;
    }else{
      Caption = "Y - VKt@C" + FileName;
    }
  } else {
    if(Modified){
      Caption = "Y * " + FileName;
    }else{
      Caption = "Y - " + FileName;
    }
  }

  MMMakeMaze->Enabled = MazeAvailable;
  TBMakeMaze->Enabled = MMMakeMaze->Enabled;

  MMDrawAnswer->Checked = Maze->bDrawAnswer;
  TBDrawAnswer->Down = MMDrawAnswer->Checked;
  TBTransparentMode->Down = Maze->TransparentMode;

  if(!MazeMade){
    MMSave->Enabled = false;
    MMDrawAnswer->Enabled = false;
    MMTransparentMode->Enabled = true;
  }else{
    MMSave->Enabled = true;
    MMTransparentMode->Enabled = false;
    MMDrawAnswer->Enabled = true;
  }
  TBSave->Enabled = MMSave->Enabled;
  TBTransparentMode->Enabled = MMTransparentMode->Enabled;
  TBDrawAnswer->Enabled = MMDrawAnswer->Enabled;

}
//---------------------------------------------------------------------------
void TFMain::ShowStatus(AnsiString msg){
  StatusBar->Panels->Items[0]->Text = msg;
}
//---------------------------------------------------------------------------
void
TFMain::Draw(void) {
  if(Mode == MODE_EDIT) {
    Maze->DrawGrid(Image->Canvas);
    Maze->DrawAnswer(Image->Canvas);
  } else {
    Maze->Draw(Image->Canvas);
  }
}
//---------------------------------------------------------------------------
/**
 * TCYύX
 */
void
TFMain::ChangeSize(void) {
  const int MIN_WIDTH = 320;

  int w = Maze->GetLX()*Maze->GridSize + Maze->LeftMargin*2;
  int h = Maze->GetLY()*Maze->GridSize + Maze->TopMargin*2;
  Image->Picture = NULL;
  Image->Height = h;
  Image->Width = w;
  ClientHeight = h + ToolBar->Height + StatusBar->Height;
  if(MIN_WIDTH < w){
    ClientWidth = w;
  }else{
    ClientWidth = MIN_WIDTH;
  }
  Draw();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMMakeMazeClick(TObject *Sender) {
  Mode = MODE_ANSWER;
  Maze->MakeMaze();
  Maze->Draw(Image->Canvas);
  MazeMade = true;
  UpdateCaption();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMDrawAnswerClick(TObject *Sender) {
  MMDrawAnswer->Checked = !MMDrawAnswer->Checked;
  Maze->bDrawAnswer = MMDrawAnswer->Checked;
  Maze->Draw(Image->Canvas);
  UpdateCaption();
}
//---------------------------------------------------------------------------
/**
 * Z[u邩mF
 * Ԃl true Ȃ瑱Ă悢
 */
bool
TFMain::SaveQuery(void){
  if(Modified == false)return true;
  int r = MessageDlg("eύXĂ܂BύXۑ܂H",mtWarning,TMsgDlgButtons() << mbYes << mbNo << mbCancel, 0);
  if(r == mrCancel)return false;
  if(r == mrYes){
    if(Save()){
      return true;
    }else{
      return false;
    }
  }
  return true;
}
//---------------------------------------------------------------------------
/**
 * t@C̓Ǎ
 */
void __fastcall
TFMain::MMLoadClick(TObject *Sender) {

  if(!SaveQuery()){
    return;
  }

  if(!OpenDialog->Execute()) {
    return;
  }

  if(!Maze->LoadFromFile(OpenDialog->FileName.c_str())) {
    ShowMessage("Failed to open File "+ OpenDialog->FileName);
    FileName = "";
    UpdateCaption();
    return;
  }

  FileName = OpenDialog->FileName;
  ChangeSize();
  MMDrawAnswer->Checked = Maze->bDrawAnswer;
  Mode = MODE_ANSWER;
  Draw();
  Modified = false;
  MazeAvailable = true;
  MazeMade = true;
  ShowStatus("H쐬{^ĂB");
  UpdateCaption();
}
//---------------------------------------------------------------------------
/**
 * ۑ
 * Z[u trueԂ
 */
bool
TFMain::Save(void){
  SaveDialog->Filter = "Maze Files (*.maz)|*.maz|All Files (*.*) |*.*";
  SaveDialog->DefaultExt = "maz";
  if(FileName == "") {
    if(!SaveDialog->Execute()) {
      return false;
    }
    FileName = SaveDialog->FileName;
  }
  Maze->SaveToFile(FileName.c_str());
  Modified = false;
  UpdateCaption();
  return true;
}
//---------------------------------------------------------------------------
/**
 * t@C̕ۑ
 */
void __fastcall
TFMain::MMSaveClick(TObject *Sender) {
  Save();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMSaveAsBitmapClick(TObject *Sender) {
  SaveDialog->Filter = "Bitmap (*.bmp)|*.bmp|All Files (*.*) |*.*";
  SaveDialog->DefaultExt = "bmp";
  if(!SaveDialog->Execute()) {
    return;
  }
  int w,h;
  Maze->GetDrawSize(w,h);
  Graphics::TBitmap *bm = new Graphics::TBitmap;
  bm->Width = w;
  bm->Height = h;
  Maze->Draw(bm->Canvas);
  bm->SaveToFile(SaveDialog->FileName);
  delete bm;
}
//---------------------------------------------------------------------------
void __fastcall TFMain::MMNewClick(TObject *Sender) {

  if(!SaveQuery())return;

  if(!FSetSize->Execute(Maze->GetLX(),Maze->GetLY(),Maze->GridSize))
    return;
  Maze->GridSize = FSetSize->GetGridSize();
  int w = FSetSize->GetWidth();
  int h = FSetSize->GetHeight();
  Maze->SetSize(w,h);
  ChangeSize();
  Mode = MODE_EDIT;
  Modified = false;
  FileName = "";
  Draw();
  UpdateCaption();  
}
//---------------------------------------------------------------------------
void __fastcall TFMain::ImageMouseDown(TObject *Sender,
                                       TMouseButton Button, TShiftState Shift, int X, int Y) {
  if(Mode != MODE_EDIT)
    return;
  int px = (X-Maze->LeftMargin);
  int py = (Y-Maze->TopMargin);
  if(px<0){
    px=-1;
  }else{
    px = px/Maze->GridSize;
  }
  if(py<0){
    py=-1;
  }else{
    py = py/Maze->GridSize;
  }
  if(px <0 && py < 0){
    return;
  }
  if(px >-1 && px < Maze->GetLX() && py >-1 && py < Maze->GetLY() ){
    ShowStatus("H̎n_͊O(DF̕)ɂĂB");
    return;
  }


  Maze->SX = px;
  Maze->SY = py;
  Maze->InitAnswer();
  ShowStatus("J[\L[ŖH쐬ĂB");
  Draw();
  Modified = false;
}
//---------------------------------------------------------------------------
/**
 * ̕ɓ邩
 */
bool
TFMain::CanMove(int Dir){
  int LX = Maze->GetLX();
  int LY = Maze->GetLY();
  int X = Maze->EX;
  int Y = Maze->EY;

  //łɒ[ɂꍇ
  switch(Dir) {
    case D_UP:
      if(Y==-1 || X==-1 || X==LX){
        return false;
      }
    break;
    case D_DOWN:
      if(Y==LY || X==-1 || X==LX){
        return false;
      }
    break;
    case D_LEFT:
      if(X==-1 || Y==-1 || Y==LY){
        return false;
      }
    break;
    case D_RIGHT:
      if(X==LX || Y==-1 || Y==LY){
        return false;
      }
    break;
  }
  //tɂǂꍇ

  switch(Dir) {
    case D_UP:
      if(Maze->AnswerBond_v[X][Y]){
        Maze->AnswerBond_v[X][Y] = false;
        Maze->EX += dx[Dir];
        Maze->EY += dy[Dir];
        Maze->OccupiedGrid[Maze->EX][Maze->EY] = false;
        Draw();
        return false;
      }
    break;
    case D_DOWN:
      if(Maze->AnswerBond_v[X][Y+1]){
        Maze->AnswerBond_v[X][Y+1] = false;
        Maze->EX += dx[Dir];
        Maze->EY += dy[Dir];
        Maze->OccupiedGrid[Maze->EX][Maze->EY] = false;
        Draw();
        return false;
      }
    break;
    case D_LEFT:
      if(Maze->AnswerBond_h[X][Y]){
        Maze->AnswerBond_h[X][Y] = false;
        Maze->EX += dx[Dir];
        Maze->EY += dy[Dir];
        Maze->OccupiedGrid[Maze->EX][Maze->EY] = false;
        Draw();
        return false;
      }
    break;
    case D_RIGHT:
      if(Maze->AnswerBond_h[X+1][Y]){
        Maze->AnswerBond_h[X+1][Y] = false;
        Maze->EX += dx[Dir];
        Maze->EY += dy[Dir];
        Maze->OccupiedGrid[Maze->EX][Maze->EY] = false;
        Draw();
        return false;
      }
    break;
  }

  return !Maze->OccupiedGrid[X+dx[Dir]][Y+dy[Dir]];
}
//---------------------------------------------------------------------------
/**
 * H쐬
 */
void
TFMain::Move(int Dir) {

  int LX = Maze->GetLX();
  int LY = Maze->GetLY();

  if(!CanMove(Dir)){
      return;
  }

  switch(Dir) {
    case D_UP:
      Maze->AnswerBond_v[Maze->EX][Maze->EY] = !Maze->AnswerBond_v[Maze->EX][Maze->EY];
    break;
    case D_DOWN:
      Maze->AnswerBond_v[Maze->EX][Maze->EY+1] = !Maze->AnswerBond_v[Maze->EX][Maze->EY+1];
    break;
    case D_LEFT:
      Maze->AnswerBond_h[Maze->EX][Maze->EY] = !Maze->AnswerBond_h[Maze->EX][Maze->EY];
    break;
    case D_RIGHT:
      Maze->AnswerBond_h[Maze->EX+1][Maze->EY] = !Maze->AnswerBond_h[Maze->EX+1][Maze->EY];
    break;
  }

  Maze->OccupiedGrid[Maze->EX][Maze->EY] = true;
  Maze->EX += dx[Dir];
  Maze->EY += dy[Dir];
  Modified = true;
  Draw();

  if(Maze->EX == -1 || Maze->EY == -1 || Maze->EX == LX || Maze->EY == LY){
    if(Maze->SX == Maze->EX && Maze->SY == Maze->EY)return;
    MazeAvailable = true;
    UpdateCaption();
    ShowStatus("H쐬{^ĂB");
    return;
  }else{
    MazeAvailable = false;
  }

  ShowStatus("O(DF̕)܂ŐL΂ĂB");
  UpdateCaption();

}
//---------------------------------------------------------------------------

void __fastcall TFMain::FormKeyDown(TObject *Sender, WORD &Key,
                                    TShiftState Shift) {
  if(Mode != MODE_EDIT)
    return;

  switch(Key) {
  case VK_UP:
    Move(D_UP);
    break;
  case VK_DOWN:
    Move(D_DOWN);
    break;
  case VK_LEFT:
    Move(D_LEFT);
    break;
  case VK_RIGHT:
    Move(D_RIGHT);
    break;
  }

}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMEnlargeGridClick(TObject *Sender) {
  Maze->GridSize+=1;
  ChangeSize();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMEnsmallGridClick(TObject *Sender) {
  Maze->GridSize-=1;
  ChangeSize();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMTransparentModeClick(TObject *Sender) {

  MMTransparentMode->Checked = !MMTransparentMode->Checked;
  TransparentColorValue = clYellow;
  TransparentColor = MMTransparentMode->Checked;
  Maze->TransparentMode = MMTransparentMode->Checked;
  Draw();
  UpdateCaption();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMInitMazeClick(TObject *Sender){
  if(!SaveQuery()){
    return;
  }
  Init();
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMAboutClick(TObject *Sender){
  FVersion->Show();        
}
//---------------------------------------------------------------------------
void __fastcall
TFMain::MMHelpClick(TObject *Sender) {
  if (!FileExists(HelpFile)){
    ShowMessage(HelpFile + "܂B");
    return;
  }
  htmlhelp->ShowHtmlHelp(this->Handle,HelpFile.c_str());
}
//---------------------------------------------------------------------------

