//---------------------------------------------------------------------------
// HNX
// $Id: KMaze.cpp 352 2006-08-12 16:42:46Z kaityo $
//---------------------------------------------------------------------------
#include <vcl.h>
#include <iostream>
#pragma hdrstop
#include <fstream>

using namespace std;

#include "KMaze.h"

TColor KMaze::BGColor = clLtGray;
TColor KMaze::FGColor = clWhite;
TColor KMaze::LineColor = clGray;
TColor KMaze::TransparentColor = clYellow;

TColor KMaze::GridColor = clGray;

const int KMaze::GridSizeMin = 3;
const int KMaze::GridSizeMax = 20;

//---------------------------------------------------------------------------
#pragma package(smart_init)

inline double
myrand(void) {
  return (double)rand()/(double)RAND_MAX;
}
//---------------------------------------------------------------------------
inline bool
myrand_bool(void) {
  if(myrand()<0.5)
    return true;
  else
    return false;
}
//---------------------------------------------------------------------------
inline bool
myrand_bool(double Rate) {
  if(myrand()<Rate)
    return true;
  else
    return false;
}
//---------------------------------------------------------------------------
/**
 *  RXgN^
 */
KMaze::KMaze(void) {
  bond_h = NULL;
  bond_v = NULL;
  ansbond_h = NULL;
  ansbond_v = NULL;
  Point = NULL;
  bOccupiedGrid = NULL;

  bDrawAnswer = true;
  GridSize = 10;
  TransparentMode = false;
  TopMargin = GridSize;
  LeftMargin = GridSize;

  StartPointColor = clRed;
  EndPointColor = clBlue;
  SX = 0;
  SY = 0;
  EX = 0;
  EY = 0;
  SetSize(40,40);
  Init();
  InitAnswer();
}
//---------------------------------------------------------------------------
/**
 *  fXgN^
\ */
KMaze::~KMaze(void) {
  if(bond_h!=NULL){
    delete bond_h;
  }
  if(bond_v!=NULL){
    delete bond_v;
  }
  if(ansbond_h!=NULL){
    delete ansbond_h;
  }
  if(ansbond_v!=NULL){
    delete ansbond_v;
  }
  if(Point!=NULL){
    delete Point;
  }
  if(bOccupiedGrid !=NULL){
    delete bOccupiedGrid;
  }
}
//---------------------------------------------------------------------------
/**
 * 𓚏
 */
void
KMaze::InitAnswer(void) {
  //𓚂̏
  for(int i=0;i<(LX+1)*LY;i++) {
    ansbond_h[i] = false;
  }
  for(int i=0;i<LX*(LY+1);i++) {
    ansbond_v[i] = false;
  }
  for(int i=0;i<LX*LY;i++){
    bOccupiedGrid[i] = false;
  }
  EX = SX;
  EY = SY;
  bDrawAnswer = true;
}
//---------------------------------------------------------------------------
/**
 * 
 */
void
KMaze::Init(void) {
  for(int i=0;i<(LX+1)*LY;i++) {
    bond_h[i] = false;
  }
  for(int i=0;i<LX*(LY+1);i++) {
    bond_v[i] = false;
  }
  for(int i=0;i<LX*LY;i++) {
    Point[i] = i;
  }
  //𓚂̃Rs[
  for(int i=0;i<(LX+1)*LY;i++) {
    bond_h[i] = ansbond_h[i];
  }
  for(int i=0;i<LX*(LY+1);i++) {
    bond_v[i] = ansbond_v[i];
  }
}
//---------------------------------------------------------------------------
/**
 *  TCYύX
 */
void
KMaze::SetSize(int _LX, int _LY) {
  LX = _LX;
  LY = _LY;
  SX = -1;
  SY = 0;
  EX = SX;
  EY = SY;

  if(bond_h!=NULL){
    delete bond_h;
  }
  if(bond_v!=NULL){
    delete bond_v;
  }
  if(ansbond_h!=NULL){
    delete ansbond_h;
  }
  if(ansbond_v!=NULL){
    delete ansbond_v;
  }
  if(Point!=NULL){
    delete Point;
  }
  if(bOccupiedGrid !=NULL){
    delete bOccupiedGrid;
  }

  bond_h = new bool[(LX+1)*LY];
  bond_v = new bool[LX*(LY+1)];
  ansbond_h = new bool[(LX+1)*LY];
  ansbond_v = new bool[LX*(LY+1)];

  Point = new int[LX*LY*2];
  bOccupiedGrid = new bool[LX*LY];

  InitAnswer();
  Init();
}
//---------------------------------------------------------------------------
void
KMaze::GetDrawSize(int &Width, int &Height) {
  Width =  LX*GridSize + LeftMargin*2;
  Height = LY*GridSize + TopMargin*2;
}
//---------------------------------------------------------------------------
void
KMaze::DrawPoint(TCanvas *Canvas) {

  Clastering();
  static TColor Colors[] = {clAqua,clBlue,clFuchsia,clGray,clGreen,clLime,clMaroon};
  int ColorNum = sizeof(Colors)/sizeof(TColor);
  for(int ix=0;ix<LX;ix++) {
    for(int iy = 0;iy < LY; iy++) {
      int x1 = ix*GridSize+2 + LeftMargin;
      int y1 = iy*GridSize+2 + TopMargin;
      int x2 = x1 + GridSize-3;
      int y2 = y1 + GridSize-3;
      int index = GetClasterIndex(ix,iy);
      Canvas->Brush->Color = Colors[index % ColorNum];
      Canvas->FillRect(Rect(x1,y1,x2,y2));
    }
  }
}
//---------------------------------------------------------------------------
/**
 *
 */
void
KMaze::Draw(TCanvas *Canvas) {
  int w = GridSize * LX+LeftMargin*2;
  int h = GridSize * LY+TopMargin*2;

  Canvas->Brush->Color = BGColor;
  Canvas->FillRect(Rect(0,0,w,h));

  Canvas->Brush->Color = FGColor;
  Canvas->FillRect(Rect(LeftMargin,TopMargin,GridSize * LX + LeftMargin,GridSize * LY + LeftMargin));


  if(bDrawAnswer) {
    DrawAnswerBold(Canvas);
  }


  Canvas->Pen->Color = LineColor;
  for(int ix=0;ix<LX+1;ix++) {
    for(int iy = 0;iy < LY; iy++) {
      if(Bond_h[ix][iy]==true)
        continue;
      int x = ix*GridSize+LeftMargin;
      int y = iy*GridSize+TopMargin;
      Canvas->MoveTo(x,y);
      Canvas->LineTo(x,y+GridSize);
    }
  }
  for(int ix=0;ix<LX;ix++) {
    for(int iy = 0;iy < LY+1; iy++) {
      if(Bond_v[ix][iy]==true)
        continue;
      int x = ix*GridSize+LeftMargin;
      int y = iy*GridSize+TopMargin;
      Canvas->MoveTo(x,y);
      Canvas->LineTo(x+GridSize,y);
    }
  }
  //DrawPoint(Canvas);
}
//---------------------------------------------------------------------------
/**
 * 𓚂`
 */
void
KMaze::DrawAnswerBold(TCanvas *Canvas) {

  Canvas->Pen->Color = clRed;
  Canvas->Brush->Color = clRed;
  for(int ix=0;ix<LX+1;ix++) {
    for(int iy = 0;iy < LY; iy++) {
      if(!AnswerBond_h[ix][iy])
        continue;
      int x = (ix-1)*GridSize+LeftMargin;
      int y = iy*GridSize+TopMargin;
      Canvas->FillRect(Rect(x,y,x+GridSize*2,y+GridSize));
    }
  }
  for(int ix=0;ix<LX;ix++) {
    for(int iy = 0;iy < LY+1; iy++) {
      if(!AnswerBond_v[ix][iy])
        continue;
      int x = ix*GridSize+LeftMargin;
      int y = (iy-1)*GridSize+TopMargin;
      Canvas->FillRect(Rect(x,y,x+GridSize,y+GridSize*2));
    }
  }
}
//---------------------------------------------------------------------------
/**
 * 𓚂`
 */
void
KMaze::DrawAnswer(TCanvas *Canvas) {

  Canvas->Pen->Color = clRed;
  for(int ix=0;ix<LX+1;ix++) {
    for(int iy = 0;iy < LY; iy++) {
      if(!AnswerBond_h[ix][iy])
        continue;
      int x = ix*GridSize+LeftMargin-GridSize/2;
      int y = iy*GridSize+TopMargin+GridSize/2;
      Canvas->MoveTo(x,y);
      Canvas->LineTo(x+GridSize,y);
    }
  }
  for(int ix=0;ix<LX;ix++) {
    for(int iy = 0;iy < LY+1; iy++) {
      if(!AnswerBond_v[ix][iy])
        continue;
      int x = ix*GridSize+LeftMargin+GridSize/2;
      int y = iy*GridSize+TopMargin-GridSize/2;
      Canvas->MoveTo(x,y);
      Canvas->LineTo(x,y+GridSize);
    }
  }
  //X^[gn_AS[n_
  int x = SX*GridSize+LeftMargin;
  int y = SY*GridSize+TopMargin;
  Canvas->Pen->Color = StartPointColor;
  Canvas->Brush->Color = StartPointColor;
  Canvas->Ellipse(x,y,x+GridSize,y+GridSize);

  x = EX*GridSize+LeftMargin;
  y = EY*GridSize+TopMargin;
  Canvas->Pen->Color = EndPointColor;
  Canvas->Brush->Color = EndPointColor;
  Canvas->Ellipse(x,y,x+GridSize,y+GridSize);
}
//---------------------------------------------------------------------------
/**
 * OccupiedGrid̉ (fobOp)
 */
void
KMaze::DrawOccupiedGrid(TCanvas *Canvas) {
  for(int ix=0;ix<LX;ix++) {
    for(int iy = 0;iy < LY; iy++) {
      if(!OccupiedGrid[ix][iy]){
        continue;
      }
      int x1 = ix*GridSize+2 + LeftMargin;
      int y1 = iy*GridSize+2 + TopMargin;
      int x2 = x1 + GridSize-3;
      int y2 = y1 + GridSize-3;
      Canvas->Brush->Color = clGray;
      Canvas->FillRect(Rect(x1,y1,x2,y2));
    }
  }
}
//---------------------------------------------------------------------------
/**
 *
 */
void
KMaze::DrawGrid(TCanvas *Canvas) {
  int w = GridSize * LX+LeftMargin*2;
  int h = GridSize * LY+TopMargin*2;

  Canvas->Brush->Color = BGColor;
  Canvas->FillRect(Rect(0,0,w,h));

  if(TransparentMode) {
    Canvas->Brush->Color = TransparentColor;
  } else {
    Canvas->Brush->Color = FGColor;
  }
  Canvas->FillRect(Rect(LeftMargin,TopMargin,GridSize * LX + LeftMargin,GridSize * LY + LeftMargin));


  Canvas->Pen->Color = GridColor;
  for(int ix=0;ix<=LX;ix++) {
    int x1 = ix*GridSize + LeftMargin;
    int y1 = TopMargin;
    int x2 = x1;
    int y2 = y1 + LY*GridSize;
    Canvas->MoveTo(x1,y1);
    Canvas->LineTo(x2,y2);
  }
  for(int iy=0;iy<=LX;iy++) {
    int x1 = TopMargin;
    int y1 = iy*GridSize + TopMargin;
    int x2 = x1 + LX*GridSize;
    int y2 = y1;
    Canvas->MoveTo(x1,y1);
    Canvas->LineTo(x2,y2);
  }
}
//---------------------------------------------------------------------------
// H쐬
//---------------------------------------------------------------------------
void
KMaze::Connect(int ix1, int iy1, int ix2, int iy2) {
  int i1 = GetClasterIndex(ix1,iy1);
  int i2 = GetClasterIndex(ix2,iy2);
  if(i1<i2)
    Point[i2] = i1;
  else
    Point[i1] = i2;
}
//---------------------------------------------------------------------------
void
KMaze::MakeMazeSub(void) {
  const double Rate = 0.2;

  for(int ix=0;ix<LX-1;ix++) {
    for(int iy=0;iy<LY;iy++) {
      if(GetClasterIndex(ix,iy)!=GetClasterIndex(ix+1,iy) && myrand_bool(Rate)) {
        Bond_h[ix+1][iy] = true;
        Connect(ix,iy,ix+1,iy);
      }
    }
  }
  for(int ix=0;ix<LX;ix++) {
    for(int iy=0;iy<LY-1;iy++) {
      if(GetClasterIndex(ix,iy)!=GetClasterIndex(ix,iy+1) && myrand_bool(Rate)) {
        Connect(ix,iy,ix,iy+1);
        Bond_v[ix][iy+1] = true;
      }
    }
  }

}
//---------------------------------------------------------------------------
void
KMaze::MakeMazeFinal(void) {
  for(int ix=0;ix<LX-1;ix++) {
    for(int iy=0;iy<LY-1;iy++) {
      if(GetClasterIndex(ix,iy)!=GetClasterIndex(ix+1,iy)) {
        Connect(ix,iy,ix+1,iy);
        Bond_h[ix+1][iy] = true;
      }
    }
  }
}
//---------------------------------------------------------------------------
void
KMaze::MakeMaze(void) {
  Init();
  Clastering();
  const int LOOP = 10;
  for(int i=0;i<LOOP;i++) {
    MakeMazeSub();
  }
  MakeMazeFinal();
}
//---------------------------------------------------------------------------
// NX^O֌W
//---------------------------------------------------------------------------
int
KMaze::GetClasterIndex(int x, int y) {
  if(x>=LX) {
    ShowMessage("Error LX");
    exit(1);
  }
  if(y>=LY) {
    ShowMessage("Error LY");
    exit(1);
  }
  int index = LX*y+x;
  while(index !=Point[index]) {
    index = Point[index];
  }
  return index;
}
//---------------------------------------------------------------------------
void
KMaze::Clastering(void) {
  for(int i=0;i<LX*LY;i++) {
    Point[i] = i;
  }
  for(int ix=0;ix<LX;ix++) {
    for(int iy=0;iy<LY;iy++) {
      if(ix!=LX-1 && Bond_h[ix+1][iy]) {
        Connect(ix,iy,ix+1,iy);
      }
      if(iy!=LY-1 && Bond_v[ix][iy+1]) {
        Connect(ix,iy,ix,iy+1);
      }
    }
  }
}
//---------------------------------------------------------------------------
// File I/O
//---------------------------------------------------------------------------
void
KMaze::SaveToFile(char *filename) {
  ofstream fout;
  fout.open(filename, ios::out|ios::binary);
  char *text = "MAZE";
  fout.write(text,sizeof(text));
  fout.write((char *)&LX,sizeof(LX));
  fout.write((char *)&LY,sizeof(LY));
  fout.write((char *)&SX,sizeof(SX));
  fout.write((char *)&SY,sizeof(SY));
  fout.write((char *)&EX,sizeof(EX));
  fout.write((char *)&EY,sizeof(EY));
  fout.write((char *)&SizeofGrid,sizeof(SizeofGrid));
  fout.write((char *)bond_h,sizeof(bool)*(LX+1)*LY);
  fout.write((char *)bond_v,sizeof(bool)*LX*(LY+1));
  fout.write((char *)ansbond_h,sizeof(bool)*(LX+1)*LY);
  fout.write((char *)ansbond_v,sizeof(bool)*LX*(LY+1));
  fout.close();
}
//---------------------------------------------------------------------------
bool
KMaze::LoadFromFile(char *filename) {
  ifstream fin;
  fin.open(filename, ios::in|ios::binary);
  char sHead[5];
  fin.read(sHead,sizeof(char)*4);
  sHead[4] = NULL;
  AnsiString Head = sHead;
  if(Head != "MAZE") {
    return false;
  }
  fin.read((char *)&LX,sizeof(LX));
  fin.read((char *)&LY,sizeof(LY));
  fin.read((char *)&SX,sizeof(SX));
  fin.read((char *)&SY,sizeof(SY));
  fin.read((char *)&EX,sizeof(EX));
  fin.read((char *)&EY,sizeof(EY));
  fin.read((char *)&SizeofGrid,sizeof(SizeofGrid));
  SetSize(LX,LY);
  fin.read((char *)bond_h,sizeof(bool)*(LX+1)*LY);
  if(fin.bad()) {
    return false;
  }
  fin.read((char *)bond_v,sizeof(bool)*LX*(LY+1));
  if(fin.bad()) {
    return false;
  }
  fin.read((char *)ansbond_h,sizeof(bool)*(LX+1)*LY);
  if(fin.bad()) {
    return false;
  }
  fin.read((char *)ansbond_v,sizeof(bool)*LX*(LY+1));
  if(fin.bad()) {
    return false;
  }
  fin.close();
  TopMargin = GridSize;
  LeftMargin = GridSize;

  return true;
}
//---------------------------------------------------------------------------

