import os
import shutil
from distutils.core import setup, Extension

def exec_command(cmd):
    print cmd
    os.system(cmd)

if os.name=='nt':
    BOOST_ROOT='C:/boost/boost_1_46_1'
    # for vc
    extra_compile_args=["/EHsc", "/wd4996"]
    libraries=[]
    include_dirs=['../../src', BOOST_ROOT]
    if os.path.exists("meshio/mqo.py"):
        os.remove("meshio/mqo.py")
    if os.path.exists("meshio/pmd.py"):
        os.remove("meshio/pmd.py")
    exec_command("swig -c++ -python -o mqo_wrap.cpp -D_MSC_VER ../mqo.i")
    exec_command("swig -c++ -python -o pmd_wrap.cpp -D_MSC_VER ../pmd.i")
    shutil.move("mqo.py", "meshio")
    shutil.move("pmd.py", "meshio")
else:
    extra_compile_args=['-std=c++0x']
    libraries=["iconv"]
    include_dirs=['../../src']
    if os.path.exists("meshio/mqo.py"):
        os.remove("meshio/mqo.py")
    if os.path.exists("meshio/pmd.py"):
        os.remove("meshio/pmd.py")
    exec_command("swig -c++ -python -o mqo_wrap.cpp ../mqo.i")
    exec_command("swig -c++ -python -o pmd_wrap.cpp ../pmd.i")
    shutil.move("mqo.py", "meshio")
    shutil.move("pmd.py", "meshio")

setup(
        name='meshio',
        version='1.0',
        description='3D mesh IO library',
        author='ousttrue',
        author_email='ousttru@gmail.com',
        url='http://meshio.sourceforge.jp/',

        packages=['meshio'],

        ext_modules = [
            Extension("meshio._mqo", 
                language="c++",
                sources=["mqo_wrap.cpp", "../../src/mqo.cpp", "../../src/binary.cpp"], 
                include_dirs=include_dirs,
                extra_compile_args=extra_compile_args,
                libraries=libraries
                ),

            Extension("meshio._pmd", 
                language="c++",
                sources=["pmd_wrap.cpp", "../../src/pmd.cpp", "../../src/binary.cpp"], 
                include_dirs=include_dirs,
                extra_compile_args=extra_compile_args,
                libraries=libraries
                ),
            ]
        )

