#
# Cookbook Name:: pig
# Recipe:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'digest/md5'

conf_files = [
  'pig-env.sh',
  'pig.properties',
  'log4j.properties',
  'log4j.properties.template'
]

def conf_template(conf_dir, conf_files, tpl_vars)
  conf_files.each {|conf_file|
    template "#{conf_dir}/#{conf_file}" do
      source "conf/#{conf_file}"
      #source "conf-#{middle_version}/#{conf_file}"
      owner 'root'
      group 'root'
      mode '0644'
      variables(tpl_vars)
    end
  }
end

version = node['pig']['version']
major_version = nil
middle_version = nil

if /^(\d+)\.(\d+)\.(\d+)$/ =~ version then
  major_version = $1
  middle_version = "#{$1}.#{$2}"
else
  Chef::Application.fatal!("Invalid Pig version: #{version}")
end

file_cache_path = Chef::Config[:file_cache_path]
install_root = "#{node['grid']['app_root']}/pig-#{version}"
tarball = "pig-#{version}.tar.gz"
tarball_md5 = "#{tarball}.md5"
#tarball_mds = "#{tarball}.mds"
downloaded_tarball = "#{file_cache_path}/#{tarball}"
downloaded_tarball_md5 = "#{file_cache_path}/#{tarball_md5}"
#downloaded_tarball_mds = "#{file_cache_path}/#{tarball_mds}"

archive_url = node['pig']['archive_url']
if ! FileTest.directory? install_root then
  remote_file downloaded_tarball_md5 do
    source "#{archive_url}/pig-#{version}/#{tarball_md5}"
    action :create_if_missing
  end
=begin
  remote_file downloaded_tarball_mds do
    source "#{archive_url}/pig-#{version}/#{tarball_mds}"
    action :create_if_missing
  end
=end

  remote_file downloaded_tarball do
    source "#{archive_url}/pig-#{version}/#{tarball}"
    action :create_if_missing
  end

  ruby_block "checksum #{downloaded_tarball}" do
    block do
      # e.g. md file format 'MD5 (pig-0.11.1.tar.gz) = 1495338b54be6961106a8a5248024945'
      /^.+\s+=\s+(\w+)$/ =~ File.read(downloaded_tarball_md5)
      checksum = $1
      Chef::Log.info "#{tarball}: MD5 = #{checksum}"
      actual_checksum = Digest::MD5.file(downloaded_tarball).to_s
      Chef::Log.info "#{tarball}: actual MD5 = #{actual_checksum}"
      if ! checksum.casecmp(actual_checksum) then
        Chef::Application.fatal!("Invalid MD5 checksum of #{downloaded_tarball}, expected: #{checksum}")
      end
=begin
      checksum = File.read(downloaded_tarball_mds).
        gsub(/(\s)+/, '').
        scan(/#{tarball}:(.+?)=([0-9A-Z]+)/).
        assoc('SHA256')[1]
      Chef::Log.info "#{tarball}: SHA256 = #{checksum}"
      if ! Digest::SHA256.file(downloaded_tarball).to_s.casecmp(checksum) then
        Chef::Application.fatal!("Invalid SHA256 checksum of #{downloaded_tarball}, expected: #{checksum}")
      end
=end
    end
    action :create
  end

  pkg = 'tar'
  resources(:package => pkg) rescue package pkg do
    action :install
  end

  bash "install_pig: #{install_root}" do
    code <<-EOC
      tar xvzf #{downloaded_tarball} -C #{node['grid']['app_root']}
    EOC
    creates install_root
  end
end
  
link node['pig']['PIG_PREFIX'] do
  to install_root
  action [:delete, :create]
end

conf_dir = "#{install_root}/conf"
tpl_vars = {}
conf_template(conf_dir, conf_files, tpl_vars)

