name 'test-cdh-on-localhost'
description 'Testing Cloudera\'s Distribution, including Apache Hadoop on local machine'

run_list(
  'role[node_commons]',
  'role[chef_utils]',
  'role[nameservice-client]',
  #'role[ganglia-gmond-ucast-localhost]',
  #'role[ganglia-gmetad-localhost]',
  #'role[ganglia-web]',
  #'role[nagios]',
  'role[yum-cdh]',
  'role[hadoop-pseudo-distributed-with-security]',
  #'role[zookeeper-pseudo-replicated-with-security]',
  #'role[hbase-pseudo-distributed-with-security]',
  ##'role[pig]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'openldap' => {
    'client' => {
      'URI' => 'ldap://localhost/',
      'BASE' => 'dc=localdomain',
      'TLS_CACERT' => '/etc/ssl/certs/cacert.pem',
      'TLS_REQCERT' => 'allow',
      'TLS_CHECKPEER' => 'yes',
      'SASL_MECH' => 'GSSAPI'
    },
    'nss-ldapd' => {
      'uri' => 'ldap://localhost/',
      'base' => 'dc=localdomain',
      'ssl' => 'start_tls',
      'tls_cacertfile' => '/etc/ssl/certs/cacert.pem',
      'tls_reqcert' => 'demand'
    },
    #'ldap_lookup_nameservices' => ['passwd', 'group']
  },
  'krb5' => {
    'libdefaults' => {
      'default_realm' => 'LOCALDOMAIN',
      # strong crypto
      'default_tgs_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'default_tkt_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5',
      'permitted_enctypes' \
        => 'aes256-cts-hmac-sha1-96 aes128-cts-hmac-sha1-96 arcfour-hmac-md5'
    }
  },
  'ganglia' => {
    'trusted_hosts' => ['127.0.0.1'],
    'web' => {
      #'Allow' => ['from .grid.example.com'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => 'LOCALDOMAIN',
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    }
  },
  'nagios' => {
    'web' => {
      #'Allow' => ['from .grid.example.com'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => 'LOCALDOMAIN',
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    },
    'check_external_commands' => '1',
    'use_regexp_matching' => '1',
    'authorized_for_system_information' => '*',
    'authorized_for_configuration_information' => '*',
    'authorized_for_system_commands' => '*',
    'authorized_for_all_services' => '*',
    'authorized_for_all_hosts' => '*',
    'authorized_for_all_service_commands' => '*',
    'authorized_for_all_host_commands' => '*',
    'check_ganglia_metric' => {
      'enabled' => true,
      'gmetad_host' => 'localhost'
    },
    'objects' => {
      'hosts' => [
        {
          'use' => 'generic-host',
          'host_name' => 'localhost4gmon',
          'address' => 'localhost'  # not 127.0.0.1
        }
      ],
      'services' => [
        # ganglia gmetad monitoring
        {
          'use' => 'generic-check_ganglia_cache-service',
          'contact_groups' => 'admins',
          'host_name' => 'localhost'
        },
        {
          'use' => 'generic-ganglia_heartbeat-service',
          'contact_groups' => 'admins',
          'host_name' => 'localhost4gmon'
          #'hostgroup_name' => 'gmetads',
        },
        # standard monitoring.
        {
          'use' => 'generic-ping-service',
          'contact_groups' => 'admins',
          #'contact_groups' => 'grid-admins',
          'host_name' => 'localhost',
          #'hostgroup_name' => 'grid-servers',
        },
        # monitoring via Ganglia
        {
          'use' => 'generic-load_one-service',
          'contact_groups' => 'admins',
          'host_name' => 'localhost4gmon'
        },
      ],
      'servicedependencies' => [
        {
          'host_name' => 'localhost',
          'service_description' => 'Cache for check_ganglia_metric',
          'dependent_host_name' => 'localhost4gmon',
          #'dependent_host_name' => '.*',
          #'dependent_hostgroup_name' => 'grid-servers',
          'dependent_service_description' => '.* via Ganglia$',
          'execution_failure_criteria' => 'c,p'
        }
      ]
    }
  },
  'zookeeper' => {
    'version' => '3.4.5'
  },
  'cdh' => {
    #'version' => '4.3.0',
    #'version' => '4.2.0',
    #'version' => '3u6',
    'version' => '3u5',
  },
  'hadoop' => {
    'install_flavor' => 'cdh',
    'HADOOP_CLASSPATH' => '',
    'HADOOP_USER_CLASSPATH_FIRST' => 'false',
=begin
    'metrics2' => {
      'namenode.sink.ganglia.servers' => 'localhost:8649',
      'datanode.sink.ganglia.servers' => 'localhost:8649',
      # for 2.0.x only
      'resourcemanager.sink.ganglia.servers' => 'localhost:8649',
      'nodemanager.sink.ganglia.servers' => 'localhost:8649',
      # for 1.0.x only
      'jobtracker.sink.ganglia.servers' => 'localhost:8649',
      'tasktracker.sink.ganglia.servers' => 'localhost:8649',
      'maptask.sink.ganglia.servers' => 'localhost:8649',
      'reducetask.sink.ganglia.servers' => 'localhost:8649'
    },
=end
    # for 2.0.x only
    'container-executor' => {
      'min.user.id' => '500'
    },
    #'yarn.nodemanager.linux-container-executor.resources-handler.class' \
    #  => 'org.apache.hadoop.yarn.server.nodemanager.util.CgroupsLCEResourcesHandler',
    # for 1.x only
    'taskcontroller' => {
      'min.user.id' => '500'
    },
  },
  'hbase' => {
    'version' => '0.94.7'
  },
  'pig' => {
    'version' => '0.11.1'
    #'version' => '0.11.0'
  }
)

override_attributes(
  'ganglia' => {
    'trusted_hosts' => ['127.0.0.1'],
=begin
    # for TEST
    'gmond_conf_type' => 'automatic',
    'automatic' => {
      #'cast_mode' => 'multi'
      'cast_mode' => 'uni'
    }
=end
  }
)

