concourse-ci Cookbook
=====================

This cookbook sets up a Concourse CI service by Docker Compose.

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
    - [cookbooks](#cookbooks)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [concourse-ci::default](#concourse-cidefault)
        - [concourse-ci::docker-compose](#concourse-cidocker-compose)
    - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- none.

### packages
- none.

### cookbooks
- `docker-grid`
- `ssl_cert`

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['concourse-ci']['docker-compose']['app_dir']`|String||`"#{node['docker-grid']['compose']['app_dir']}/concourse"`|
|`['concourse-ci']['docker-compose']['pgdata_dir']`|String|Path string or nil (unset).|`"#{node['concourse-ci']['docker-compose']['app_dir']}/database"`|
|`['concourse-ci']['docker-compose']['web_keys_dir']`|String|Path string.|`"#{node['concourse-ci']['docker-compose']['app_dir']}/keys/web"`|
|`['concourse-ci']['docker-compose']['worker_keys_dir']`|String|Path string.|`"#{node['concourse-ci']['docker-compose']['app_dir']}/keys/worker"`|
|`['concourse-ci']['docker-compose']['pgdata_dir']`|String|Path string or nil (unset).|`"#{node['concourse-ci']['docker-compose']['app_dir']}/database"`|
|`['concourse-ci']['docker-compose']['config_format_version']`|String|Read only. `docker-compose.yml` format version. Only version 1 is supported now.|`'1'`|
|`['concourse-ci']['docker-compose']['config']`|Hash|`docker-compose.yml` configurations.|See `attributes/default.rb`|

## Usage

### Recipes

#### concourse-ci::default

This recipe does nothing.

#### concourse-ci::docker-compose

This recipe generates SSH keys of each node and a `docker-compose.yml` file for the Concourse CI service.

### Role Examples

- `roles/concourse.rb`

```ruby
name 'concourse'
description 'Concourse'

run_list(
  'role[docker]',
  'recipe[concourse-ci::docker-compose]',
)

image = 'concourse/concourse:2.6.0'
port = '18080'

override_attributes(
  'concourse-ci' => {
    'docker-compose' => {
      'config' => {
        # Version 1 docker-compose format
        'concourse-web' => {
          'image' => image,
          'ports' => [
            "#{port}:8080",
          ],
          'environment' => {
            'CONCOURSE_EXTERNAL_URL' => "http://192.168.1.3:#{port}",
          },
        },
        'concourse-worker' => {
          'image' => image,
        },
      },
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
