apt_utils Cookbook
==================

This cookbook includes apt utility (apt-cacher-ng, apt mirroring site setup and apt source configuration) recipes.

Requirements
------------

#### packages
- `commons` - local cookbook.

Attributes
----------

#### apt_utils::default

|Key|Type|Description (with examples)|Default|
|:--|:--|:--|:--|
|`['apt_utils']['conf']['proxy']['sequence']`|String|Sequence number of apt proxy configuration file (ver. 0.1.1 or later)|`'80'`|
|`['apt_utils']['conf']['proxy']['ftp']`|String|Proxy setting for FTP (ver. 0.1.1 or later)|`'nil'`|
|`['apt_utils']['conf']['proxy']['http']`|String|Proxy setting for HTTP (ver. 0.1.1 or later)|`'nil'`|
|`['apt_utils']['conf']['proxy']['https']`|String|Proxy setting for HTTPS (ver. 0.1.1 or later)|`'nil'`|
|`['apt_utils']['apt-cacher-ng']['CacheDir']`|String|path to cache directory|`'/var/cache/apt-cacher-ng'`|
|`['apt_utils']['apt-cacher-ng']['LogDir']`|String|path to log directory.|`'/var/log/apt-cacher-ng'`|
|`['apt_utils']['apt-cacher-ng']['Port']`|String|service port number.|`'3142'`|
|`['apt_utils']['apt-cacher-ng']['BindAddress']`|String|service bind address|`''` (0.0.0.0)|
|`['apt_utils']['mirror']['user']`|String|service user.|`'apt-mirror'`|
|`['apt_utils']['mirror']['cron_period']`|String|cron period expression.|`'#0 4   * * *'` (inactive)|
|`['apt_utils']['mirror']['base_path']`|String|mirroring base path.|`'/var/spool/apt-mirror'`|
|`['apt_utils']['mirror']['nthreads']`|String|worker threads number.|`'20'`|
|`['apt_utils']['mirror']['_tilde']`|||`'0'`|
|`['apt_utils']['mirror']['country']`|String|mirroring source country.|`'us'`|
|`['apt_utils']['mirror']['distributions']['debian']`|Hash|Debian's mirroring apt lines.|refer to attributes/default.rb|
|`['apt_utils']['mirror']['distributions']['ubuntu']`|Hash|Ubuntu's mirroring apt lines.|refer to attributes/default.rb|
|`['apt_utils']['source']['apt_lines']['ubuntu']`|Array|apt source lines.|refer to attributes/default.rb|

Usage
-----
#### apt_utils::conf
- deploy apt configuration files to the /etc/apt/apt.conf.d directory.

#### apt_utils::apt-cacher-ng

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[apt_utils::apt-cacher-ng]"
  ]
}
```

#### apt_utils::mirror

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[apt_utils::mirror]"
  ]
}
```

#### apt_utils::source

```json
{
  "name":"my_node",
  "run_list": [
    "recipe[apt_utils::source]"
  ]
}
```

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2013-2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
