#
# Cookbook Name:: bubbleupnp-server
# Attributes:: default
#
# Copyright 2019, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

ver = '0.9-5'
image_name = nil
base_image = nil
site_url = nil
pkg = nil

case node['kernel']['machine']
when 'x86_64'
  image_name = 'bubbleupnpserver'
  base_image = 'openjdk:8-jre-slim'
  site_url = 'https://launchpad.net/~bubbleguuum/+archive/bubbleupnpserver/+files'
  pkg = "bubbleupnpserver_#{ver}_all.deb"
when 'armv7l'
  image_name = 'bubbleupnpserver-armhf'
  base_image = 'arm32v7/openjdk:8-jre'
  site_url = 'https://launchpad.net/~bubbleguuum/+archive/bubbleupnpserver/+files'
  pkg = "bubbleupnpserver_#{ver}_all.deb"
end

default['bubbleupnp-server']['Dockerfile'] = {
  'FROM' => base_image,
}

default['bubbleupnp-server']['docker-compose']['autopilot'] = {
  'enabled' => false,
  'log_dir' => '/var/log',
  'wait_time' => '180s',
  'docker-compose_opts' => '--no-ansi',
  #'docker-compose_opts' => '',  # for the old docker-compose
}
default['bubbleupnp-server']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/bubbleupnp-server"
default['bubbleupnp-server']['docker-compose']['data_dir'] = "#{node['bubbleupnp-server']['docker-compose']['app_dir']}/data"

default['bubbleupnp-server']['docker-compose']['dot_env'] = {
  'NAME' => image_name,
  'VER' => ver,
  'site_url' => site_url,
  'pkg' => pkg,
  'REGISTRY' => 'whitestar',
}

force_override['bubbleupnp-server']['docker-compose']['config_format_version'] = '2'
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'bubbleupnp-server' => {
      'build' => {
        'context' => './',
        'args' => {
          'site_url' => '${site_url}',
          'pkg' => '${pkg}',
        },
      },
      'image' => '${REGISTRY}/${NAME}:${VER}',
      'restart' => 'always',
      'network_mode' => 'host',
      'volumes' => [
        # These volumes will be set by the bubbleupnp-server::docker-compose recipe automatically.
        #"#{node['bubbleupnp-server']['docker-compose']['data_dir']}/configuration.xml:/usr/share/bubbleupnpserver/configuration.xml:rw",
        #"#{node['bubbleupnp-server']['docker-compose']['data_dir']}/cache:/usr/share/bubbleupnpserver/cache:rw",
        #"#{node['bubbleupnp-server']['docker-compose']['data_dir']}/Playlists:/usr/share/bubbleupnpserver/Playlists:rw",
      ],
    },
  },
}

default['bubbleupnp-server']['docker-compose']['config'] = version_2_config
