#
# Cookbook Name:: minim-server
# Recipe:: docker-compose
#
# Copyright 2018-2019, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

doc_url = 'https://hub.docker.com/r/tromatik/docker-minimserver/'

include_recipe 'platform_utils::kernel_user_namespace'
include_recipe 'docker-grid::compose'

app_dir = node['minim-server']['docker-compose']['app_dir']
data_dir = node['minim-server']['docker-compose']['data_dir']

[
  app_dir,
  data_dir,
].each {|dir|
  resources(directory: dir) rescue directory dir do
    owner 'root'
    group 'root'
    mode '0755'
    recursive true
  end
}

config_srvs = node['minim-server']['docker-compose']['config']['services']
override_config_srvs = node.override['minim-server']['docker-compose']['config']['services']
force_override_config_srvs = node.force_override['minim-server']['docker-compose']['config']['services']
envs = {}
vols = config_srvs['minim-server']['volumes'].to_a

vols.push("#{data_dir}:/opt/minimserver/data:rw")

# merge environment hash
force_override_config_srvs['minim-server']['environment'] = envs unless envs.empty?
# reset vlumes array.
override_config_srvs['minim-server']['volumes'] = vols unless vols.empty?

[
  '.env',
  'docker-compose.yml',
  'minimserver.config',
].each {|conf_file|
  template "#{app_dir}/#{conf_file}" do
    source "opt/docker-compose/app/minim-server/#{conf_file}"
    owner 'root'
    group 'root'
    mode '0644'
  end
}

dockerfile_tpl = 'Dockerfile'
dockerfile_tpl = 'Dockerfile.armhf' if node['kernel']['machine'] == 'armv7l'
template "#{app_dir}/Dockerfile" do
  source "opt/docker-compose/app/minim-server/#{dockerfile_tpl}"
  owner 'root'
  group 'root'
  mode '0644'
end

# autopilot
srv = 'minim-server'
template "/etc/cron.d/#{srv}-local" do
  source  "etc/cron.d/#{srv}-local"
  owner 'root'
  group 'root'
  mode '0644'
  action :delete unless node['minim-server']['docker-compose']['autopilot']['enabled']
end

log 'minim-server docker-compose post install message' do
  message <<-"EOM"
Note: You must execute the following command manually.
  See #{doc_url}
  * Start:
    $ cd #{app_dir}
    $ docker-compose up -d
  * Stop
    $ docker-compose down
EOM
end
