#
# Cookbook Name:: platform_utils
# Recipe:: grub_default
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

unless File.exist?('/boot/grub/grub.cfg')
  Chef::Log.warn('recipe[platform_utils::grub_default] GRUB 2 is not installed yet.')
  return
end

execute 'update-grub2' do
  user 'root'
  command 'update-grub2'
  action :nothing
  only_if 'which update-grub2'
end

dir = '/etc/default/grub.d'
resources(directory: dir) rescue directory dir do
  owner 'root'
  group 'root'
  mode '0755'
end

template '/etc/default/grub.d/override.cfg' do
  source  'etc/default/grub.d/override.cfg'
  owner 'root'
  group 'root'
  mode '0644'
  notifies :run, 'execute[update-grub2]'
end
