#
# Cookbook Name:: platform_utils
# Recipe:: mount
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# autopilot
srv = 'mount'
template "/etc/cron.d/#{srv}-local" do
  source  "etc/cron.d/#{srv}-local"
  owner 'root'
  group 'root'
  mode '0644'
  action :delete unless node['platform_utils']['mount']['autopilot']['enabled']
end

template "/usr/local/bin/#{srv}-local" do
  source  "usr/local/bin/#{srv}-local"
  owner 'root'
  group 'root'
  mode '0755'
  action :delete unless node['platform_utils']['mount']['autopilot']['enabled']
end
