squid-proxy Cookbook
====================

This cookbook sets up a Squid server.

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [squid-proxy::default](#squid-proxydefault)
        - [squid-proxy::server](#squid-proxyserver)
    - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### platforms
- Debian, Ubuntu

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['squid-proxy']['autopilot']`|Hash|Autopilot configurations.|See `attribute/default.rb`|
|`['squid-proxy']['with_cgi']`|Boolean|with Cache Manager CGI.|`'false'`|
|`['squid-proxy']['conf']['http_port']`|String|e.g. `'192.168.1.10:3128'`|`'0.0.0.0:3128'`|
|`['squid-proxy']['conf']['extra_http_ports']`|Array|Extra service bind addresses. e.g. `['127.0.0.1:3128']`|`[]`|
|`['squid-proxy']['conf']['http_access_allow_localnet']`|Boolean|Allows local private network access.|`false`|
|`['squid-proxy']['conf']['acl_rules']`|Array|Extra ACL directive lines.|`[]`|
|`['squid-proxy']['conf']['extra_confs']`|Array|Extra configuration lines.|`[]`|

## Usage

### Recipes

#### squid-proxy::default

This recipe does nothing.

#### squid-proxy::server

This recipe installs Squid server.

### Role Examples

- `roles/squid.rb`

```ruby
name 'squid'
description 'Squid server'

run_list(
  'recipe[squid-proxy::server]',
)

override_attributes(
  'squid-proxy' => {
    'with_cgi' => true,
    'conf' => {
      'http_port' => '192.168.1.10:3128',
      'extra_http_ports' => [
        '127.0.0.1:3128',
      ],
      'http_access_allow_localnet' => true,
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
