ups_utils Cookbook
==================

This cookbook sets up Network UPS Tools.

## Contents

- [Requirements](#requirements)
    - [platforms](#platforms)
    - [packages](#packages)
- [Attributes](#attributes)
- [Usage](#usage)
    - [Recipes](#recipes)
        - [ups_utils::default](#ups_utilsdefault)
        - [ups_utils::nut](#ups_utilsnut)
        - [ups_utils::nut-cgi](#ups_utilsnut-cgi)
    - [Role Examples](#role-examples)
    - [Secrets management by Chef Vault](#secrets-management-by-chef-vault)
- [License and Authors](#license-and-authors)

## Requirements

### platforms

- Debian >= 9.0
- Ubuntu >= 16.04

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['ups_utils']['nut']['secrets']`|String|Chef-vault conf. for secrets (password,...).|empty. See `attributes/default.rb`|
|`['ups_utils']['nut']['hosts.conf']`|Hash|Conf. for CGI.|empty. See `attributes/default.rb`|
|`['ups_utils']['nut']['hosts.conf']['MONITORs']`|Array|e.g. `['by80s@upsd.example.com "@upsd - Omron BY80S"']`|empty.|
|`['ups_utils']['nut']['nut.conf']`|Hash||See `attributes/default.rb`|
|`['ups_utils']['nut']['nut.conf']['MODE']`|String|`'none'`, `'netclient'`, `'standalone'` or `'netserver'`|`'none'`|
|`['ups_utils']['nut']['ups.conf']`|Hash||empty. See `attributes/default.rb`|
|`['ups_utils']['nut']['upsd.conf']`|Hash||See `attributes/default.rb`|
|`['ups_utils']['nut']['upsd.conf']['LISTENs']`|Array|e.g. `['LISTEN 0.0.0.0 3493']`|empty.|
|`['ups_utils']['nut']['upsd.users']`|String||empty. See `attributes/default.rb`|
|`['ups_utils']['nut']['upsmon.conf']`|Hash||See `attributes/default.rb`|
|`['ups_utils']['nut']['upsmon.conf']['MONITORs']`|Array|e.g. `['by80s@localhost 1 upsmon {{upsmon_password}} master']`|empty.|
|`['ups_utils']['nut']['udev_usbups_rules']`|Array|e.g. `['ATTR{idVendor}=="0590", ATTR{idProduct}=="00a1", MODE="664", GROUP="nut"']`|empty.|

## Usage

### Recipes

#### ups_utils::default

This recipe does nothing.

#### ups_utils::nut

This recipe sets up a NUT server or client.

#### ups_utils::nut-cgi

This recipe configures NUT CGI.

### Role Examples

- `roles/nut-server.rb`

```ruby
name 'nut-server'
description 'Network UPS Tools Server'

upsd_port = '3493'

run_list(
  'recipe[ups_utils::nut]',
)

override_attributes(
  'ups_utils' => {
    'nut' => {
      'secrets' => {
        'upsmon_password' => {
          'vault' => 'nut',
          'name' => 'upsmon',
          'env_context' => false,
          'key' => 'password',  # real hash path: "/password"
        },
      },    
      'nut.conf' => {
        'MODE' => 'netserver',
      },
      'ups.conf' => {
        'by80s' => {
          'driver' => 'blazer_usb',
          'port' => 'auto',
          'desc' => '"Omron UPS"',
          'vendorid' => '0590',
          'productid' => '00a1',
          'subdriver' => 'ippon',
          'default.battery.voltage.high' => '27.2',
          'default.battery.voltage.low' => '23.5',
        },
      },
      'upsd.conf' => {
        'LISTENs' => [
          "0.0.0.0 #{upsd_port}",
        ],
      },
      'upsd.users' => {
        'upsmon' => {
          'password' => '{{upsmon_password}}',
          'upsmon' => 'master',
        },
      },    
      'upsmon.conf' => {
        'MONITORs' => [
          'by80s@localhost 1 upsmon {{upsmon_password}} master',
        ],
      },
      'udev_usbups_rules' => [
        '# Omron BY80S - blazer_usb',
        'ATTR{idVendor}=="0590", ATTR{idProduct}=="00a1", MODE="664", GROUP="nut"',
      ],
    },
  },
)
```

- `roles/nut-client.rb`

```ruby
name 'nut-client'
description 'Network UPS Tools Client'

nut_host = 'upsd.example.com'

run_list(
  'recipe[ups_utils::nut]',
)

override_attributes(
  'ups_utils' => {
    'nut' => {
      'secrets' => {
        'upsmon_password' => {
          'vault' => 'nut',
          'name' => 'upsmon',
          'env_context' => false,
          'key' => 'password',  # real hash path: "/password"
        },
      },    
      'nut.conf' => {
        'MODE' => 'netclient',
      },
      'upsd.conf' => {
        'LISTENs' => [
          # empty,
        ],
      },
      'upsmon.conf' => {
        'MONITORs' => [
          "by80s@#{nut_host} 1 upsmon {{upsmon_password}} master",
        ],
      },
    },
  },
)
```

- `roles/nut-cgi.rb`

```ruby
name 'nut-cgi'
description 'Network UPS Tools CGI'

nut_host = 'upsd.example.com'

run_list(
  'role[nut-client]',
  'recipe[ups_utils::nut-cgi]',
)

override_attributes(
  'ups_utils' => {
    'nut' => {
      'hosts.conf' => {
        'MONITORs' => [
          %(by80s@#{nut_host} "@#{nut_host.split('.')[0]} - Omron BY80S"),
        ],
      },
    },
  },
)
```

### Secrets management by Chef Vault

- create vault items.

```text
$ cat ~/sec/tmp/upsmon_password.json
{
  "password":"********************"
}

$ cd $CHEF_REPO_PATH
$ knife vault create nut upsmon --json ~/sec/tmp/upsmon_password.json
```

- grant reference permission to the upsd host

```text
$ knife vault update nut upsmon -S 'name:upsd-host.example.com'
```

- modify attributes

```ruby
override_attributes(
  'ups_utils' => {
    'nut' => {
      'secrets' => {
        'upsmon_password' => {
          'vault' => 'nut',
          'name' => 'upsmon',
          # single password or nested hash password path delimited by slash
          'env_context' => false,
          'key' => 'password',  # real hash path: "/password"
          # or nested hash password path delimited by slash
          #'env_context' => true,
          #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
        },
      },     
      # ...
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2018, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
