#
# Cookbook Name:: ups_utils
# Attributes:: default
#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['ups_utils']['nut'] = {
  'secrets' => {
=begin
    # <key_name> => <chef-vault conf.>,
    # `{{<key_name>}}` in the templates (`upsd.users`, `upsmon.conf`) are replaced
    # with the each value in chef-vault.
    'upsmon_password' => {
      'vault' => 'nut',
      'name' => 'upsmon',
      # single password or nested hash password path delimited by slash
      'env_context' => false,
      'key' => 'password',  # real hash path: "/password"
      # or nested hash password path delimited by slash
      #'env_context' => true,
      #'key' => 'hash/path/to/password',  # real hash path: "/#{node.chef_environment}/hash/path/to/password"
    },
=end
  },
  'hosts.conf' => {  # for cgi
    'MONITORs' => [
      #'by80s@localhost "Local - Omron BY80S"',
      #'by80s@upsd.example.com "@upsd - Omron BY80S"',
    ],
  },
  'nut.conf' => {
    'MODE' => 'none',
  },
  'ups.conf' => {
    # 'by80s' => {
    #   'driver' => 'blazer_usb',
    #   'port' => 'auto',
    #   'desc' => '"Omron UPS"',
    #   'vendorid' => '0590',
    #   'productid' => '00a1',
    #   'subdriver' => 'ippon',
    #   'default.battery.voltage.high' => '27.2',
    #   'default.battery.voltage.low' => '23.5',
    # },
  },
  'upsd.conf' => {
    'LISTENs' => [
      #'LISTEN 127.0.0.1 3493',
      #'LISTEN 0.0.0.0 3493',
    ],
  },
  'upsd.users' => {
    # 'upsmon' => {
    #   'password' => '{{upsmon_password}}',
    #   'upsmon' => 'master',
    # },
  },
  'upsmon.conf' => {
    'MONITORs' => [
      #'by80s@localhost 1 <user> {{user_password}} master',
      #'by80s@localhost 1 upsmon {{upsmon_password}} master',
    ],
  },
  'udev_usbups_rules' => [
    # Omron BY80S - blazer_usb
    #'ATTR{idVendor}=="0590", ATTR{idProduct}=="00a1", MODE="664", GROUP="nut"',
  ],
}
