#
# Copyright 2017-2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'concourse-on-docker'
description 'Concourse on Docker'

image = 'concourse/concourse'
#port = '8080'  # '8443' (for https)
#concourse_cn = 'concourse.io.example.com'

run_list(
  #'recipe[ssl_cert::server_key_pairs]',  # for https
  'role[docker]',
  'recipe[concourse-ci::docker-compose]',
  #'recipe[concourse-ci::fly]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  # for https
  'ssl_cert' => {
    #'common_names' => [
      #concourse_cn,
    #],
  },
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
    },
    'compose' => {
      'skip_setup' => false,
    },
  },
  'concourse-ci' => {
    'with_ssl_cert_cookbook' => false,  # or true (for https)
    'ssl_cert' => {
      #'common_name' => concourse_cn,
    },
    'docker-compose' => {
      # Version 1 docker-compose format (default)
      'config' => {
        'concourse-web' => {
          'image' => image,
          #'ports' => [
            #"#{port}:8080",  # If you sepecify no value, Chef will sets '8080:8080'.
            #"#{port}:8443",  # for https
          #],
          'environment' => {
            #'CONCOURSE_RESOURCE_CHECKING_INTERVAL' => '1m',
            # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
            #'CONCOURSE_EXTERNAL_URL' => "http://192.168.1.3:#{port}",  # or "https://192.168.1.3:#{port}"
            #'CONCOURSE_TLS_BIND_PORT' => '8443',  # activate HTTPS
            # These environments will be set by the concourse-ci::docker-compose recipe automatically.
            #'CONCOURSE_TLS_CERT' => '/root/server.crt',
            #'CONCOURSE_TLS_KEY' => '/root/server.key',
          },
          #'volumes' => [
            # These volumes will be set by the concourse-ci::docker-compose recipe automatically.
            #"#{server_cert_path(node['concourse-ci']['ssl_cert']['common_name'])}:/root/server.crt:ro",
            #"#{server_key_path(node['concourse-ci']['ssl_cert']['common_name'])}:/root/server.key:ro",
          #],
        },
        'concourse-worker' => {
          'image' => image,
        },
      },
=begin
      # Version 2 docker-compose format
      'config_format_version' => '2',
      'config' => {
        'services' => {
          'concourse-web' => {
            'image' => image,
            #'ports' => [
              #"#{port}:8080",  # If you sepecify no value, Chef will sets '8080:8080'.
              #"#{port}:8443",  # for https
            #],
            'environment' => {
              #'CONCOURSE_RESOURCE_CHECKING_INTERVAL' => '1m',
              # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
              #'CONCOURSE_EXTERNAL_URL' => "http://192.168.1.3:#{port}",  # or "https://192.168.1.3:#{port}"
              #'CONCOURSE_TLS_BIND_PORT' => '8443',  # activate HTTPS
              # These environments will be set by the concourse-ci::docker-compose recipe automatically.
              #'CONCOURSE_TLS_CERT' => '/root/server.crt',
              #'CONCOURSE_TLS_KEY' => '/root/server.key',
            },
            #'volumes' => [
              # These volumes will be set by the concourse-ci::docker-compose recipe automatically.
              #"#{server_cert_path(node['concourse-ci']['ssl_cert']['common_name'])}:/root/server.crt:ro",
              #"#{server_key_path(node['concourse-ci']['ssl_cert']['common_name'])}:/root/server.key:ro",
            #],
          },
          'concourse-worker' => {
            'image' => image,
          },
        },
      },
=end
    },
  },
)
