#
# Copyright 2016-2019, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'docker-new-repo'
description 'Docker CE by the new repository'

run_list(
  'recipe[docker-grid::engine]',
  'recipe[docker-grid::compose]',
)

#env_run_lists

default_attributes(
)

override_attributes(
  'docker-grid' => {
    'install_flavor' => 'dockerproject',
    'dockerproject' => {
      'enable_new_repo' => true,
    },
    'compose' => {
      #'skip_setup' => true,  # default: false
      'auto_upgrade' => true,  # default: false
      'version' => '1.24.0',
    },
    'engine' => {
      #'skip_setup' => true,  # default: false
      # new package: `docker-ce`
      #'version' => '',  # '' (=latest) or exact version
      'version_on_centos' => '',  # latest
      #'version_on_centos' => '18.06.0.ce-3',  # '18.03.1.ce-1', '17.12.1.ce-1',
      'version_on_ubuntu' => '',  # latest
      #'version_on_ubuntu' => '18.06.0~ce~3-0',  # '18.03.1~ce-0', '17.12.1~ce-0'
      'storage-driver_on_centos' => 'overlay2',  # defacto: 'devicemapper'
      'storage-driver_on_ubuntu' => 'overlay2',  # defacto: 'aufs'
      #'userns-remap' => 'default',
      'daemon_extra_options' => [
        '-H fd://',
        #'--bip=192.168.100.1/24 --fixed-cidr=192.168.100.0/24',
        # for docker >= 1.10, docker-engine >= 1.12 (on rhel family)
        # '-H fd://' option automatically removed by this cookbook.
        # See https://github.com/docker/docker/issues/22847
      ].join(' '), 
    },
  },
)
