#
# Copyright 2016-2019, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'docker'
description 'Docker Engine'

# if you set `nil` to its attribute, you can deactivate its override.
docker_ver_on_centos = nil
#docker_ver_on_centos = '17.12.1.ce-1'
docker_ver_on_ubuntu = nil
#docker_ver_on_ubuntu = '17.12.1~ce-0'
docker_compose_ver = '1.24.0'

docker_bip        = '192.168.100.1/24'
docker_fixed_cidr = '192.168.100.0/24'

run_list(
  'role[docker-new-repo]',
)

#env_run_lists

default_attributes(
)

override_attributes(
  'docker-grid' => {
    'engine' => {
      #'version' => '',  # '' (=latest) or exact version
      'version_on_centos' => docker_ver_on_centos,  # '18.06.0.ce-3', '18.03.1.ce-1', '17.12.1.ce-1'
      'version_on_ubuntu' => docker_ver_on_ubuntu,  # '18.06.0~ce~3-0', '18.03.1~ce-0', '17.12.1~ce-0' 
      #'storage-driver_on_centos' => 'overlay2',  # defacto: 'devicemapper'
      #'storage-driver_on_ubuntu' => 'overlay2',  # defacto: 'aufs'
      'daemon_extra_options' => [
        '-H fd://',
        "--bip=#{docker_bip} --fixed-cidr=#{docker_fixed_cidr}",
      ].join(' '),
    },
    'compose' => {
      'version' => docker_compose_ver,
    },
  },
)
