#
# Copyright 2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'screwdriver-all-on-docker-override'
description 'Screwdriver with all components on Docker (customized)'

# if you set `nil` to its attribute, you can deactivate its override.
docker_skip_setup = false
docker_ver_on_centos = '17.12.1.ce-1'
docker_ver_on_ubuntu = '17.12.1~ce-0'
docker_compose_skip_setup = false
docker_compose_ver = '1.21.2'
network_mode_bridge = false

docker_bip        = '192.168.100.1/24'
docker_fixed_cidr = '192.168.100.0/24'
api_ver    = 'latest'
ui_ver     = 'latest'
store_ver  = 'latest'
launch_ver = 'latest'

# Default ports
#ui_port     = '9000'
#api_port    = '9001'
#store_port  = '9002'

run_list(
  'role[screwdriver-all-on-docker]',
)

override_attributes(
  'docker-grid' => {
    'engine' => {
      'skip_setup' => docker_skip_setup,
      #'version' => '',  # '' (=latest) or exact version
      'version_on_centos' => docker_ver_on_centos,  # '18.06.0.ce-3', '18.03.1.ce-1', '17.12.1.ce-1'
      'version_on_ubuntu' => docker_ver_on_ubuntu,  # '18.06.0~ce~3-0', '18.03.1~ce-0', '17.12.1~ce-0' 
      #'storage-driver_on_centos' => 'overlay',   # defacto: 'devicemapper'
      #'storage-driver_on_ubuntu' => 'overlay2',  # defacto: 'aufs'
      'daemon_extra_options' => [
        '-H fd://',
        "--bip=#{docker_bip} --fixed-cidr=#{docker_fixed_cidr}",
      ].join(' '),
    },
    'compose' => {
      'skip_setup' => docker_compose_skip_setup,
      'version' => docker_compose_ver,
    },
  },
  'screwdriver' => {
    'api' => {
      'config' => {
        'executor' => {
          #'plugin' => 'docker',
          'docker' => {
            'options' => {
              'launchVersion' => launch_ver,
            },
          },
        },
        'scms' => {
          # **REQUIRED**: SCM settings
          'github.com' => {  # id and display name
            'plugin' => 'github',
            'config' => {
              # These 3 secrets should be set by the following `['screwdriver']['api']['scms_vault_items']` attribute.
              'oauthClientId' => 'YOU-PROBABLY-WANT-SOMETHING-HERE',  # The client id used for OAuth with github. GitHub OAuth (https://developer.github.com/v3/oauth/)
              'oauthClientSecret' => 'AGAIN-SOMETHING-HERE-IS-USEFUL',  # The client secret used for OAuth with github
              'secret' => 'SUPER-SECRET-SIGNING-THING',  # Secret to add to GitHub webhooks so that we can validate them
              #'gheHost' => 'github.screwdriver.cd',  # [Optional] GitHub enterprise host
              'username' => 'sd-buildbot',  # [Optional] Username for code checkout
              'email' => 'dev-null@screwdriver.cd',  # [Optional] Email for code checkout
              'privateRepo' => false,  # [Optional] Set to true to support private repo; will need read and write access to public and private repos (https://developer.github.com/v3/oauth/#scopes)
            },
          },
        },
      },
    },
    'docker-compose' => {
      'network_mode_bridge' => network_mode_bridge,
      'config' => {
        'services' => {
          'api' => {
            'image' => "screwdrivercd/screwdriver:#{api_ver}",
            'ports' => [
              #"#{api_port}:80",
            ],
            'environment' => {
              #'NODE_TLS_REJECT_UNAUTHORIZED' => '0',  # for self-signed cetificates
              # The following variables will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_UI' => "http://#{node['fqdn']}:#{ui_port}",
              #'ECOSYSTEM_STORE' => "http://#{node['fqdn']}:#{store_port}",
              #'DATASTORE_SEQUELIZE_DIALECT' => 'mysql',  # or 'postgres'
            },
            # examples for development
            # 'volumes' => [
            #   '/your/home/dev/github.com/your_org/screwdriver:/usr/src/app/node_modules/screwdriver-api:rw',
            #   '/your/home/dev/github.com/your_org/data-schema:/usr/src/app/node_modules/screwdriver-data-schema:rw',
            # ],
          },
          'ui' => {
            'image' => "screwdrivercd/ui:#{ui_ver}",
            'ports' => [
              #"#{ui_port}:80",
            ],
            'environment' => {
              # These variables will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_API' => "http://#{node['fqdn']}:#{api_port}",
              #'ECOSYSTEM_STORE' => "http://#{node['fqdn']}:#{store_port}",
            },
          },
          'store' => {
            'image' => "screwdrivercd/store:#{store_ver}",
            'ports' => [
              #"#{store_port}:80",
            ],
            'environment' => {
              # This variable will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_UI' => "http://#{node['fqdn']}:#{ui_port}",
            },
            # examples for development
            # 'volumes' => [
            #   '/your/home/dev/github.com/your_org/store:/usr/src/app/node_modules/screwdriver-store:rw',
            # ],
          },
          'db' => {
          },
          'screwdriver.s3' => {
          },
        },
      },
    },
  },
)
