#
# Copyright 2017-2018, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'screwdriver-on-docker'
description 'Screwdriver on Docker'

# Default ports
#ui_port     = '9000'
#api_port    = '9001'
#store_port  = '9002'

run_list(
  'role[docker]',
  'recipe[screwdriver::docker-compose]',
)

override_attributes(
  'docker-grid' => {
    'engine' => {
      #'skip_setup' => true,  # default: false
    },
    'compose' => {
      #'skip_setup' => true,  # default: false
    },
  },
  'screwdriver' => {
    'api' => {
      'config' => {
        'scms' => {
=begin
          # **REQUIRED**: SCM settings
          'github.com' => {  # id and display name
            'plugin' => 'github',
            'config' => {
              # These 3 secrets should be set by the following `['screwdriver']['api']['scms_vault_items']` attribute.
              'oauthClientId' => 'YOU-PROBABLY-WANT-SOMETHING-HERE',  # The client id used for OAuth with github. GitHub OAuth (https://developer.github.com/v3/oauth/)
              'oauthClientSecret' => 'AGAIN-SOMETHING-HERE-IS-USEFUL',  # The client secret used for OAuth with github
              'secret' => 'SUPER-SECRET-SIGNING-THING',  # Secret to add to GitHub webhooks so that we can validate them
              #'gheHost' => 'github.screwdriver.cd',  # [Optional] GitHub enterprise host
              'username' => 'sd-buildbot',  # [Optional] Username for code checkout
              'email' => 'dev-null@screwdriver.cd',  # [Optional] Email for code checkout
              'privateRepo' => false,  # [Optional] Set to true to support private repo; will need read and write access to public and private repos (https://developer.github.com/v3/oauth/#scopes)
            },
          },
=end
        },
      },
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'api' => {
            'image' => 'screwdrivercd/screwdriver:latest',
            'ports' => [
              #"#{api_port}:80",
            ],
            'environment' => {
              #'NODE_TLS_REJECT_UNAUTHORIZED' => '0',  # for self-signed cetificates
              # The following variables will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_UI' => "http://#{node['fqdn']}:#{ui_port}",
              #'ECOSYSTEM_STORE' => "http://#{node['fqdn']}:#{store_port}",
            },
          },
          'ui' => {
            'image' => 'screwdrivercd/ui:latest',
            'ports' => [
              #"#{ui_port}:80",
            ],
            'environment' => {
              # These variables will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_API' => "http://#{node['fqdn']}:#{api_port}",
              #'ECOSYSTEM_STORE' => "http://#{node['fqdn']}:#{store_port}",
            },
          },
          'store' => {
            'image' => 'screwdrivercd/store:latest',
            'ports' => [
              #"#{store_port}:80",
            ],
            'environment' => {
              # This variable will be set by the screwdriver::docker-compose recipe automatically.
              #'ECOSYSTEM_UI' => "http://#{node['fqdn']}:#{ui_port}",
            },
          },
        },
      },
    },
  },
)
