name 'test-ah2-on-localhost'
description 'Testing Apache Hadoop 2.x on local machine'

run_list(
  'role[test-on-localhost]',
)

#env_run_lists()

default_attributes(
  'zookeeper' => {
    'version' => '3.4.5'
  },
  'hadoop' => {
    'version' => '2.1.0-beta',
    #'version' => '2.0.6-alpha',
    'hadoop.http.authentication.type' => 'simple',
    'metrics2' => {
      'namenode.sink.ganglia.servers' => 'localhost:8649',
      'datanode.sink.ganglia.servers' => 'localhost:8649',
      # for 2.0.x only
      'resourcemanager.sink.ganglia.servers' => 'localhost:8649',
      'nodemanager.sink.ganglia.servers' => 'localhost:8649',
    },
    # for 2.0.x only >>
    #'yarn.nodemanager.admin-env' => 'MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX',
    'yarn.nodemanager.admin-env' => 'MALLOC_ARENA_MAX=$MALLOC_ARENA_MAX,LD_LIBRARY_PATH=${HADOOP_COMMON_HOME}/lib/native',
    'yarn.nodemanager.linux-container-executor.resources-handler.class' \
      => 'org.apache.hadoop.yarn.server.nodemanager.util.CgroupsLCEResourcesHandler',
  },
  'hbase' => {
    'version' => '0.94.7'
  },
  'pig' => {
    'version' => '0.11.1'
    #'version' => '0.11.0'
  }
)

#override_attributes() 
