#
# Cookbook Name:: docker-grid
# Attributes:: default
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['docker-grid']['apt_repo'] = {
  'url' => 'https://apt.dockerproject.org/repo',
  'keyserver' => 'hkp://p80.pool.sks-keyservers.net:80',
  'recv-keys' => '58118E89F3A912897C070ADBF76221572C52609D',
}
default['docker-grid']['yum_repo'] = {
  'baseurl' => 'https://yum.dockerproject.org/repo/main/centos/$releasever/',
  'gpgcheck' => '1',
  'gpgkey' => 'https://yum.dockerproject.org/gpg',
}
default['docker-grid']['compose']['auto_upgrade'] = false
default['docker-grid']['compose']['release_base_url'] = 'https://github.com/docker/compose/releases/download/1.9.0'
default['docker-grid']['compose']['release_url'] = "#{node['docker-grid']['compose']['release_base_url']}/docker-compose-#{node['kernel']['name']}-#{node['kernel']['machine']}"
default['docker-grid']['engine']['version_on_centos'] = '1.11.2-1'  # 1.12.3-1, 1.11.2-1, 1.10.3-1
default['docker-grid']['engine']['version_on_ubuntu'] = '1.11.2-0'  # 1.12.3-0, 1.11.2-0
default['docker-grid']['engine']['version'] = node.value_for_platform(
  ['centos', 'redhat'] => {
    'default' => "#{node['docker-grid']['engine']['version_on_centos']}.el#{node['platform_version'].to_i}.#{node['platform']}",
  },
  'ubuntu' => {
    'default' => "#{node['docker-grid']['engine']['version_on_ubuntu']}~#{node['lsb']['codename']}",
  }
)
default['docker-grid']['engine']['storage-driver_on_centos'] = 'overlay'
default['docker-grid']['engine']['storage-driver_on_ubuntu'] = 'aufs'
default['docker-grid']['engine']['storage-driver'] = node.value_for_platform(
  ['centos', 'redhat'] => {
    'default' => node['docker-grid']['engine']['storage-driver_on_centos'],
  },
  'ubuntu' => {
    'default' => node['docker-grid']['engine']['storage-driver_on_ubuntu'],
  }
)
default['docker-grid']['engine']['userns-remap'] = nil  # default: inactive
default['docker-grid']['engine']['daemon_extra_options'] = '-H fd://'
default['docker-grid']['engine']['users_allow'] = []
