#
# Cookbook Name:: drillbook
# Recipe:: attribute_test
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Attribute Tests
[
  [2,  node.default],
  [6,  node.force_default],
  [8,  node.normal],
  [10, node.override],
  [14, node.force_override],
].each {|pos, method|
  (pos..14).each {|num|
    method['drillbook']["case#{num}"] = pos
    method['drillbook']["case-array#{num}"] = [pos]
    method['drillbook']["case-empty#{num}"] = [] if pos == num
  }
}

result = ''
result_a = ''
result_e = ''

(1..14).each {|num|
  result   += "node['drillbook']['case#{num}']: " + node['drillbook']["case#{num}"].to_s + "\n"
  result_a += "node['drillbook']['case-array#{num}']: " + node['drillbook']["case-array#{num}"].to_s + "\n"
  result_e += "node['drillbook']['case-empty#{num}']: " + node['drillbook']["case-empty#{num}"].to_s + "\n"
}

log result
log result_a
log result_e
