#
# Cookbook Name:: lxcs
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['lxcs']['lxc']['env']['lxc'] = {
  'LXC_AUTO' => 'true',
  'BOOTGROUPS' => 'onboot,',
  'SHUTDOWNDELAY' => '5',
  'OPTIONS' => '',
  'STOPOPTS' => '-a -A -s',
  'USE_LXC_BRIDGE' => 'false',
}
default['lxcs']['lxc']['env']['lxc-net'] = {
  'USE_LXC_BRIDGE' => 'true',
  'LXC_BRIDGE' => 'lxcbr0',
  'LXC_ADDR' => '10.0.3.1',
  'LXC_NETMASK' => '255.255.255.0',
  'LXC_NETWORK' => '10.0.3.0/24',
  'LXC_DHCP_RANGE' => '10.0.3.2,10.0.3.254',
  'LXC_DHCP_MAX' => '253',
}
# Content is line string's array or single string.
default['lxcs']['lxc']['default.conf'] = [
  'lxc.network.type = veth',
  'lxc.network.link = lxcbr0',
  'lxc.network.flags = up',
  'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
]
default['lxcs']['lxc']['extra-default.conf'] = {
=begin
  # Content is line string's array or single string
  'default-br0.conf' => [
    'lxc.network.type = veth',
    'lxc.network.link = br0',
    'lxc.network.flags = up',
    'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
  ],
  'default-br0-unpriv.conf' => [
    'lxc.network.type = veth',
    'lxc.network.link = br0',
    'lxc.network.flags = up',
    'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
    'lxc.id_map = u 0 100000 65536',
    'lxc.id_map = g 0 100000 65536',
  ],
=end
}
# Content is line string's array or single string
default['lxcs']['lxc']['lxc-usernet'] = [
  # USERNAME TYPE BRIDGE COUNT
  #'alice veth lxcbr0 10',
  # ...
]

default['lxcs']['lxd']['with_zfs'] = false
default['lxcs']['lxd']['users_allow'] = []
