lxcs Cookbook
=============

This cookbook sets up LinuxContainers.org products (LXC, LXD).

## Contents

- [Contents](#contents)
- [Requirements](#requirements)
  - [Platforms](#platforms)
  - [Cookbooks](#cookbooks)
- [Attributes](#attributes)
- [Usage](#usage)
  - [Recipes](#recipes)
    - [lxcs::default](#lxcsdefault)
    - [lxcs::lxc](#lxcslxc)
    - [lxcs::lxd](#lxcslxd)
  - [Role Examples](#role-examples)
- [License and Authors](#license-and-authors)

## Requirements

### Platforms

- Ubuntu

### Cookbooks

- None.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['lxcs']['lxc']['env']['lxc']`|Hash|Content in the `/etc/default/lxc`.|See `attributes/default.rb`|
|`['lxcs']['lxc']['env']['lxc-net']`|Hash|Content in the `/etc/default/lxc-net`.|See `attributes/default.rb`|
|`['lxcs']['lxc']['default.conf']`|Array, String|Content (line strings or single string) in the `/etc/lxc/default.conf`.|See `attributes/default.rb`|
|`['lxcs']['lxc']['extra-default.conf']`|Hash|Additional container configuration default files.|`{}`, See `attributes/default.rb`|
|`['lxcs']['lxc']['lxc-usernet']`|Array, String|Content (line strings or single string) in the `/etc/lxc/lxc-usernet`.|`[]`, See `attributes/default.rb`|
|`['lxcs']['lxd']['with_zfs']`|Boolean|with ZFS utility.|`false`|
|`['lxcs']['lxd']['users_allow']`|Array|Non-root users allowed to manage Linux containers on LXD.|`[]`|

## Usage

### Recipes

#### lxcs::default

This recipe does nothing.

#### lxcs::lxc

This recipe installs LXC.

#### lxcs::lxd

This recipe sets up LXD.

### Role Examples

- `roles/lxc.rb`

```ruby
name 'lxc'
description 'LXC role.'

run_list(
  'recipe[lxcs::lxc]',
)

override_attributes(
  'lxcs' => {
    'lxc' => {
      'extra-default.conf' => {
        'default-br0.conf' => [
          'lxc.network.type = veth',
          'lxc.network.link = br0',
          'lxc.network.flags = up',
          'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
        ],
        'default-br0-unpriv.conf' => [
          'lxc.network.type = veth',
          'lxc.network.link = br0',
          'lxc.network.flags = up',
          'lxc.network.hwaddr = 00:16:3e:xx:xx:xx',
          'lxc.id_map = u 0 100000 65536',
          'lxc.id_map = g 0 100000 65536',
        ],
      },
      'lxc-usernet' => [
        'alice veth lxcbr0 10',
        'bob veth lxcbr0 10',
      ],
    },
  },
)
```

- `roles/lxd.rb`

```ruby
name 'lxd'
description 'LXD role.'

run_list(
  'recipe[lxcs::lxd]',
)

override_attributes(
  'lxcs' => {
    'lxd' => {
      'with_zfs' => true,
      'users_allow' => [
        'alice',
        'bob',
      ],
    },
  },
)
```

## License and Authors

- Author:: whitestar at osdn.jp

```text
Copyright 2017, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
