#
# Cookbook Name:: grid
# Recipe:: ops-utils
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%w{
  dsh_ipass
  gridctl
}.each {|command|
  template "/usr/local/bin/#{command}" do
    source "usr/local/bin/#{command}"
    owner 'root'
    group 'root'
    mode '0755'
  end
}

template '/etc/profile.d/gridctl.sh' do
  source 'etc/profile.d/gridctl.sh'
  owner 'root'
  group 'root'
  mode '0644'
end

