#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'

name 'grid-gpm'
description 'Grid provisioning master node'

run_list(
  'role[node_commons]',
  'role[ganglia-gmond]',
  'role[berkshelf-api-server]',
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

this_subcluster = Grid::CLUSTERS[:base][:provisioningmasters]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
=begin
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}
=end

default_attributes(
)

override_attributes(
  'berkshelf_api' => {
    'host' => "gpm00.#{Grid::DOMAIN}",
    'proxy_port' => 6280,
    'app_host' => '127.0.0.1',
    'port' => 26200,
    'proxy' => {
      'ssl' => true,
      'ssl_certificate'     => '/etc/pki/tls/certs/01gpm00_server.crt',
      'ssl_certificate_key' => '/etc/pki/tls/private/01gpm00_server.key',
    } 
    'config' => {
      'build_interval' => 180.0,
      'endpoints' => [
        {
          'type' => 'chef_server',
          'options' => {
            'url' => 'https://api.opscode.com/organizations/gridverse',  # hosted chef
            'client_key' => '/etc/berkshelf/api-server/gridverse-berkshelf.pem',
            'client_name' => 'berkshelf',
            'ssl_verify' => true
          }
        },
        {
          'type' => 'chef_server',
          'options' => {
            #'url' => 'https://gpm00.grid.example.com/organizations/grid',  # chef12
            'url' => 'https://gpm00.grid.example.com',  # chef11
            'client_key' => '/etc/berkshelf/api-server/grid-berkshelf.pem',
            'client_name' => 'berkshelf',
            'ssl_verify' => false
          }
        },
      ],
    },
  },
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => this_subcluster[:alias],
      'owner' => Grid::DOMAIN
    },
    # static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)
