#
# Cookbook Name:: hdp
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

default['hdp']['version'] = '1.3.1'
default['hdp']['archive_url'] = 'http://public-repo-1.hortonworks.com'  # or local mirror site.
default['hdp']['yum_repo']['update'] = false
default['hdp']['yum_repo']['only_for_mirroring'] = false
default['hdp']['yum_repo']['mirroring']['platform'] = 'centos'  # centos|rhel|suse
default['hdp']['yum_repo']['mirroring']['platform_version'] = '6'
#default['hdp']['yum_repo']['mirroring']['arch'] = 'x86_64' # in the future i386|x86_64

default['hdp']['yum_mirror']['user'] = 'yum-mirror'
default['hdp']['yum_mirror']['cron_period'] = '#0 3   * * *'  # default: inactive
default['hdp']['yum_mirror']['base_path'] = '/var/spool/hdp-mirror'
default['hdp']['yum_mirror']['yum_conf'] = value_for_platform_family(
  'debian' => '/etc/yum/yum.conf',
  'rhel' => '/etc/yum.conf'
)
default['hdp']['yum_mirror']['repos_dir'] = value_for_platform_family(
  'debian' => '/etc/yum/repos.d',
  'rhel' => '/etc/yum.repos.d'
)
default['hdp']['yum_mirror']['repo_ids'] = []
#default['hdp']['yum_mirror']['arch'] = 'x86_64' # in the future i386|x86_64
default['hdp']['yum_mirror']['url_alias_with_authority_part'] = true
#default['hdp'][''] = 

