#
# Copyright 2016-2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'docker'
description 'Docker Engine'

run_list(
  'recipe[docker-grid::engine]',
  'recipe[docker-grid::compose]',
)

#env_run_lists

default_attributes(
)

override_attributes(
  'docker-grid' => {
    'install_flavor' => 'dockerproject',
    #'install_flavor' => 'os-repository',
    'compose' => {
      'skip_setup' => true,  # default: false
    },
    'engine' => {
      'version' => '',  # latest
      #'skip_setup' => true,  # default: false
      #'version_on_centos' => '17.03.1.ce-1',  # docker-engine
      #'version_on_centos' => '1.13.1-1',      # docker-engine
      #'version_on_centos' => '1.12.6-1',      # docker-engine
      #'version_on_centos' => '1.12.6-11',     # docker
      #'version_on_centos' => '1.12.5-14',     # docker
      #'version_on_centos' => '1.11.2-1',      # docker-engine
      #'version_on_centos' => '1.10.3-1',      # docker-engine
      #'version_on_centos' => '1.10.3-59',     # docker      
      #'version_on_ubuntu' => '17.05.0~ce-0',  # docker-engine
      #'version_on_ubuntu' => '17.03.1~ce-0',  # docker-engine
      #'version_on_ubuntu' => '1.13.1-0',      # docker-engine
      #'version_on_ubuntu' => '1.12.6-0',      # docker-engine
      #'version_on_ubuntu' => '1.12.3-0ubuntu4~16.04.2',  # docker.io
      #'version_on_ubuntu' => '1.11.2-0',      # docker-engine
      #'version_on_ubuntu' => '1.10.3-0ubuntu6',          # docker.io
      'storage-driver_on_centos' => 'overlay',
      'storage-driver_on_ubuntu' => 'overlay',  # default: aufs
      #'userns-remap' => 'default',
      'daemon_extra_options' => [
        '-H fd://',
        #'-H fd:// --bip=192.168.100.1/24 --fixed-cidr=192.168.100.0/24',
        # for docker >= 1.10, docker-engine >= 1.12 (on rhel family)
        # '-H fd://' option automatically removed by this cookbook.
        # See https://github.com/docker/docker/issues/22847
      ].join(' '), 
    },
  },
)
