#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'devops-suite-on-docker'
description 'DevOps Suite on Docker'

dockerd_extra_opts = [
  '-H fd://',
  '--bip=192.168.100.1/24 --fixed-cidr=192.168.100.0/24',
].join(' ')
network_mode_bridge = false
aptly_port         =  '7080'  # default: 8080
aptly_api_port     =  '7081'  # default: 8081
concourse_port     =  '8080'
jenkins_port       =  '9080'  # default: 8080
jenkins_agent_port = '50000'  # default: 50000
jenkins_home_path = '/opt/docker-compose/app/jenkins/home'
gitlab_http_port   =    '80'  # default: 80, Note: 8080 already in use.
gitlab_ssh_port    =  '2022'
nexus_ver = '3'
nexus_port = nexus_ver == '3' ? '8081' : '8071'

run_list(
  'role[docker]',
  'role[aptly-on-docker]',
  'role[concourse-on-docker]',
  'role[gitlab-on-docker]',
  'role[gitlab-runner]',
  'role[jenkins-on-docker]',
  "role[nexus#{nexus_ver}-on-docker]",
)

#env_run_lists()

attrs = {
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
      'daemon_extra_options' => dockerd_extra_opts
    },
    'compose' => {
      'skip_setup' => false,
    },
  },
  'apt_utils' => {
    'aptly' => {
      'docker-compose' => {
        'config' => {
          'services' => {
            'reverseproxy' => {
              'ports' => [
                "#{aptly_port}:8080",
                "#{aptly_api_port}:8081",
              ],
            },
            'aptly' => {
            },
          },
        },
      },
    },
  },
  'concourse-ci' => {
    'docker-compose' => {
      'config' => {
        # Version 1 docker-compose format
        'concourse-db' => {
        },
        'concourse-web' => {
          'ports' => [
            "#{concourse_port}:8080",
          ],
          'environment' => {
            # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
            #'CONCOURSE_EXTERNAL_URL' => "http://#{node['ipaddress']}:#{concourse_port}",
          },
        },
        'concourse-worker' => {
          'environment' => {
          },
        },
      },
    },
  },
  'gitlab-grid' => {
    'gitlab.rb' => {
      #'external_url' => "http://#{gitlab_cn}:#{gitlab_http_port}",
      'gitlab_rails' => {
        #'time_zone' => 'Asia/Tokyo',
        'gitlab_shell_ssh_port' => gitlab_ssh_port.to_i,
      },
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'gitlab' => {
            #'hostname' => gitlab_cn,
            'ports' => [
              "#{gitlab_http_port}:#{gitlab_http_port}",
              "#{gitlab_ssh_port}:22",
            ],
            'network_mode' => 'bridge',  # for the Container Registry feature.
          },
        },
      },
    },
    'runner-docker-compose' => {
      'import_ca' => false,
    },
  },
  'jenkins-grid' => {
    'docker-compose' => {
      'jenkins_home' => {
        'path' => jenkins_home_path,
      },
      'config' => {
        'services' => {
          'jenkins' => {
            'ports' => [
              "#{jenkins_port}:8080",
              "#{jenkins_agent_port}:50000",
            ],
          },
        },
      },
    },
  },
  'nexus-grid' => {
    'docker-compose' => {
      'config' => {
        'services' => {
          'reverseproxy' => {
            'ports' => [
              "#{nexus_port}:8081",
            ],
          },
          'nexus' => {
            #'image' => 'sonatype/nexus3',  # => role[nexus2/3-on-docker]
          },
        },
      },
    },
  },
}

if network_mode_bridge
  aptly_srvs = attrs['apt_utils']['aptly']['docker-compose']['config']['services']
  aptly_srvs['reverseproxy']['network_mode'] = 'bridge'
  aptly_srvs['reverseproxy']['links'] = [
    'aptly',
  ]
  aptly_srvs['aptly']['network_mode'] = 'bridge'

  nexus_srvs = attrs['nexus-grid']['docker-compose']['config']['services']
  nexus_srvs['reverseproxy']['network_mode'] = 'bridge'
  nexus_srvs['reverseproxy']['links'] = [
    'nexus',
  ]
  nexus_srvs['nexus']['network_mode'] = 'bridge'
end

#default_attributes()

override_attributes(attrs)
