#
# Cookbook Name:: Commons
# Library:: PackageUtils
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

module Commons
  module PackageUtils
    def get_cron_pkg_name
      case node[:platform_family]
      when 'debian'then return 'cron'
      when 'rhel'  then return 'crontabs'
      end
    end


    def get_cron_serv_name
      case node[:platform_family]
      when 'debian'then return 'cron'
      when 'rhel'  then return 'crond'
      end
    end


    def get_httpd_pkg_name
      case node[:platform_family]
      when 'debian'then return 'apache2'
      when 'rhel'  then return 'httpd'
      end
    end


    def get_httpd_serv_name
      case node[:platform_family]
      when 'debian'then return 'apache2'
      when 'rhel'  then return 'httpd'
      end
    end


    def get_jsvc_pkg_name
      case node[:platform_family]
      when 'debian' then return 'jsvc'
      when 'rhel'   then return 'jakarta-commons-daemon-jsvc'
      end
    end


    def get_libbz2_pkg_name
      case node[:platform_family]
      when 'debian' then return 'libbz2-1.0'
      when 'rhel'   then return 'bzip2-libs'
      end
    end
  end
end

